/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.adjust;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustDimensionEntry;
import kd.fi.bcm.common.adjust.AdjustEntryDyn;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.adjust.IAdjustEntry;
import kd.fi.bcm.common.adjust.IAdjustHead;

public class AdjustHeadDyn
extends IAdjustHead {
    private DynamicObject data = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_rptadjust"));

    @Override
    public void set(String key, Object value) {
        this.data.set(key, value);
    }

    @Override
    public Object get(String key) {
        return this.data.get(key);
    }

    @Override
    public void addCommonPageMemberDim(Long dimId, Long memberId, Integer seq) {
        DynamicObjectCollection commembentry = this.data.getDynamicObjectCollection("commembentry");
        DynamicObject comm = commembentry.addNew();
        comm.set("commembid", (Object)memberId);
        comm.set("comdimension", (Object)dimId);
        comm.set("seq", (Object)seq);
    }

    @Override
    public void addSpreadMemberDim(Long dimId, Integer seq) {
        DynamicObjectCollection commembentry = this.data.getDynamicObjectCollection("spreadmembentry");
        DynamicObject comm = commembentry.addNew();
        comm.set("seq", (Object)seq);
        comm.set("spreaddimension", (Object)dimId);
    }

    @Override
    public IAdjustEntry newEntry() {
        AdjustEntryDyn adjustEntry = new AdjustEntryDyn();
        this.addEntry(adjustEntry);
        return adjustEntry;
    }

    @Override
    public Collection<AdjustDimensionEntry> getPageLayoutDim(boolean isSpread) {
        if (!isSpread) {
            DynamicObjectCollection commembentry = this.data.getDynamicObjectCollection("commembentry");
            if (commembentry != null) {
                return commembentry.stream().map(e -> new AdjustDimensionEntry((Long)e.get("comdimension"), (Long)e.get("commembid"), (Integer)e.get("seq"))).collect(Collectors.toList());
            }
        } else {
            DynamicObjectCollection spreadmembentry = this.data.getDynamicObjectCollection("spreadmembentry");
            return spreadmembentry.stream().map(e -> new AdjustDimensionEntry((Long)e.get("spreaddimension"), (Integer)e.get("seq"))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Pair<DynamicObject, Collection<DynamicObject>> genDynamic() {
        AtomicInteger showseq = new AtomicInteger(1);
        return Pair.onePair(this.data, this.entrys.stream().sorted().map(e -> {
            e.set("summoney", AdjustOperationUtils.handleSummoney(e.getDebit(), e.getCredit()));
            if (OrgRelaProcessMembPool.isRelaProcess(this.getProcess()) && this.isMultiplecurrency().booleanValue() && (e.get("cvtbeforedebit") == null && e.get("cvtbeforecredit") == null || BigDecimal.ZERO.equals(e.get("cvtbeforecredit")) && BigDecimal.ZERO.equals(e.get("cvtbeforedebit")))) {
                e.set("cvtbeforedebit", e.get("debit"));
                e.set("cvtbeforecredit", e.get("credit"));
                e.set("cvtbeforesummoney", e.get("summoney"));
                e.set("debit", null);
                e.set("credit", null);
                e.set("summoney", null);
            }
            DynamicObject adjustdata = e.genDynamic();
            adjustdata.set("adjust", (Object)this.data);
            adjustdata.set("showseq", (Object)showseq.incrementAndGet());
            return adjustdata;
        }).collect(Collectors.toList()));
    }

    @Override
    public Object getData() {
        return this.data;
    }
}

