/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.adjust;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustDimensionEntry;
import kd.fi.bcm.common.adjust.AdjustEntryMap;
import kd.fi.bcm.common.adjust.AdjustModelParser;
import kd.fi.bcm.common.adjust.IAdjustEntry;
import kd.fi.bcm.common.adjust.IAdjustHead;

public class AdjustHeadMap
extends IAdjustHead {
    private Map<String, Object> data = new HashMap<String, Object>(16);

    @Override
    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.data.get(key);
    }

    @Override
    public void addCommonPageMemberDim(Long dimId, Long memberId, Integer seq) {
        Collection commembentry = (Collection)this.data.computeIfAbsent("commembentry", a -> new ArrayList());
        HashMap<String, Number> comm = new HashMap<String, Number>(16);
        comm.put("commembid", memberId);
        comm.put("comdimension", dimId);
        comm.put("seq", seq);
        commembentry.add(comm);
    }

    @Override
    public void addSpreadMemberDim(Long dimId, Integer seq) {
        Collection spreadmembentry = (Collection)this.data.computeIfAbsent("spreadmembentry", a -> new ArrayList());
        HashMap<String, Number> comm = new HashMap<String, Number>(16);
        comm.put("spreaddimension", dimId);
        comm.put("seq", seq);
        spreadmembentry.add(comm);
    }

    @Override
    public IAdjustEntry newEntry() {
        AdjustEntryMap adjustEntry = new AdjustEntryMap();
        this.addEntry(adjustEntry);
        return adjustEntry;
    }

    @Override
    public Collection<AdjustDimensionEntry> getPageLayoutDim(boolean isSpread) {
        if (!isSpread) {
            Collection commembentry = (Collection)this.data.computeIfAbsent("commembentry", a -> new ArrayList());
            if (commembentry != null) {
                return commembentry.stream().map(e -> new AdjustDimensionEntry((Long)e.get("comdimension"), (Long)e.get("commembid"), (Integer)e.get("seq"))).collect(Collectors.toList());
            }
        } else {
            Collection spreadmembentry = (Collection)this.data.computeIfAbsent("spreadmembentry", a -> new ArrayList());
            return spreadmembentry.stream().map(e -> new AdjustDimensionEntry((Long)e.get("spreaddimension"), (Integer)e.get("seq"))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Pair<DynamicObject, Collection<DynamicObject>> genDynamic() {
        AtomicInteger showseq = new AtomicInteger(1);
        DynamicObject adjustHead = AdjustModelParser.createAdjustHead(this.data, -1);
        return Pair.onePair(adjustHead, this.entrys.stream().sorted().map(e -> {
            DynamicObject adjustdata = e.genDynamic();
            adjustdata.set("adjust", (Object)adjustHead);
            adjustdata.set("showseq", (Object)showseq.incrementAndGet());
            return adjustdata;
        }).collect(Collectors.toList()));
    }

    public AdjustHeadMap parseByMap(Map<String, Object> datafrom) {
        this.data = datafrom;
        List<Map> adjustDatas = datafrom.getOrDefault("adjustDatas", Collections.emptyList());
        adjustDatas.forEach(e -> {
            AdjustEntryMap adjustEntry = (AdjustEntryMap)this.newEntry();
            adjustEntry.setData((Map<String, Object>)e);
        });
        return this;
    }

    @Override
    public Map<String, Object> getData() {
        Long id = this.getId();
        this.data.put("adjustDatas", this.entrys.stream().map(e -> {
            Map entry = (Map)e.getData();
            entry.put("adjust", id);
            return entry;
        }).collect(Collectors.toList()));
        return this.data;
    }
}

