/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.fi.bcm.common.auditlog.ESDateUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AuditLogESIndexStrategy {
    private static final String DATE_YEAR_MONTH_FORMATTER = "yyyy-MM";

    private static String buildAuditIndexName(String modelNumber, AuditLogIndexType type, Date dataDate) {
        if (type == null) {
            throw new IllegalArgumentException("param AuditLogIndexType can not be null");
        }
        if (Objects.isNull(dataDate)) {
            dataDate = new Date();
        }
        return String.format("audit-%s-%s.%s", modelNumber.toLowerCase(Locale.ENGLISH), type.name(), ESDateUtils.formatUTCDateFormat(dataDate, DATE_YEAR_MONTH_FORMATTER));
    }

    public static String decideSearchIndexName(String modelNumber, AuditLogIndexType type, Date startDate, Date endDate) {
        List<String> availableMonthIndexes = AuditLogESIndexStrategy.listIndexNames(modelNumber, type, startDate, endDate);
        if (availableMonthIndexes.size() > 5) {
            Date now = new Date();
            String thisMonthIndex = AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, type, now);
            return thisMonthIndex.replace(ESDateUtils.formatUTCDateFormat(now, DATE_YEAR_MONTH_FORMATTER), "*");
        }
        return String.join((CharSequence)",", availableMonthIndexes);
    }

    public static List<String> listIndexNames(String modelNumber, AuditLogIndexType type, Date startDate, Date endDate) {
        boolean expression2;
        boolean expression1;
        if (type == null) {
            throw new IllegalArgumentException("param AuditLogIndexType can not be null");
        }
        boolean bl = expression1 = startDate != null && endDate != null;
        if (!expression1) {
            throw new IllegalArgumentException("param startDate or endDate can not be null");
        }
        boolean bl2 = expression2 = startDate.getTime() <= endDate.getTime();
        if (!expression2) {
            throw new IllegalArgumentException("param startDate can not exceed endDate");
        }
        ArrayList<String> indexes = new ArrayList<String>(10);
        String startDateIndex = AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, type, startDate);
        indexes.add(startDateIndex);
        while (startDate.getTime() < endDate.getTime()) {
            String oneMonthIndex = AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, type, startDate = DateUtils.addMonths((Date)startDate, (int)1));
            if (indexes.contains(oneMonthIndex)) continue;
            indexes.add(oneMonthIndex);
        }
        String endDateIndex = AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, type, endDate);
        if (!indexes.contains(endDateIndex)) {
            indexes.add(endDateIndex);
        }
        return indexes;
    }

    public static String buildDataIndexName(String modelNumber) {
        return AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, AuditLogIndexType.data, new Date());
    }

    public static String buildSummaryIndexName(String modelNumber) {
        return AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, AuditLogIndexType.summary, new Date());
    }

    public static String buildOpLogIndexName(String modelNumber) {
        return AuditLogESIndexStrategy.buildAuditIndexName(modelNumber, AuditLogIndexType.oplog, new Date());
    }

    public static void main(String[] args) throws ParseException {
        AuditLogESIndexStrategy.buildAuditIndexName("aa", AuditLogIndexType.data, null);
        Date date = DateUtils.parseDate((String)"2020-03-01 00:01:00", (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        AuditLogESIndexStrategy.buildAuditIndexName("aa", AuditLogIndexType.data, date);
        Date startDate = DateUtils.parseDate((String)"2020-01-01 00:01:00", (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        Date endDate = DateUtils.parseDate((String)"2020-03-03 00:01:00", (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        AuditLogESIndexStrategy.listIndexNames("ttt", AuditLogIndexType.data, startDate, endDate);
    }

    public static enum AuditLogIndexType {
        summary,
        data,
        oplog;

    }
}

