/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.xcontent.XContentType;

public class ESClient {
    public static final String SERVER_PREFIX = "elasticsearch.server";
    public static final String SERVER_REGION = "audit";
    public static final String SERVER_IP = "ip";
    public static final String SERVER_PORT = "port";
    public static final String SERVER_HTTP_PORT = "httpport";
    public static final String SERVER_INDEX = "index";
    public static final String SERVER_ENABLE = "enable";
    public static final String SERVER_CLUSTERNAME = "clustername";
    public static final String SERVER_TOTAL_FIELDS = "totalfields";
    public static final String SERVER_SHARDS_NUMBER = "shardsnumber";
    public static final String SERVER_REPLICAS_NUMBER = "replicasnumber";
    public static final String SERVER_USERNAME = "username";
    public static final String SERVER_PW = "password";
    public static final String SERVER_BATCH_SIZE = "batchSize";
    public static final int DEFAULT_TOTAL_FIELDS = 8000;
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final int DEFAULT_SHARDS_NUMBER = 2;
    public static final int DEFAULT_REPLICAS_NUMBER = 1;
    private static final Map<String, RestHighLevelClient> CLIENT_CACHE_MAP = new HashMap<String, RestHighLevelClient>(8);
    private static final Log LOG = LogFactory.getLog(ESClient.class);

    public static ErrorCode getErrorCode() {
        return new ErrorCode("bcm.audit.", ResManager.loadKDString((String)"ES\u670d\u52a1\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ESClient_0", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    public static void createIndex(RestHighLevelClient client, String index, Map<String, Integer> settings) {
        CreateIndexRequest req = new CreateIndexRequest(index);
        try {
            client.indices().create(req.settings(settings), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public static void createIndexMapping(RestHighLevelClient client, String index, String type, String fieldsMapping) {
        PutMappingRequest req = new PutMappingRequest(new String[]{index});
        req.type(type);
        req.source(fieldsMapping, XContentType.JSON);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putMapping(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"Failed to create index:" + index + res});
        }
    }

    public static boolean isIndexExist(RestHighLevelClient client, String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return client.indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public static void insertDoc(String summaryIndexName, Map<String, Object> doc) {
        RestHighLevelClient esClient = ESClient.getESClient();
        try {
            esClient.index(new IndexRequest(summaryIndexName).type("_doc").source(doc, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new KDException(ESClient.getErrorCode(), "failed to insert data to es: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void insertDoc(String summaryIndexName, String docJson) {
        RestHighLevelClient esClient = ESClient.getESClient();
        try {
            esClient.index(new IndexRequest(summaryIndexName).type("_doc").source(docJson, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new KDException(ESClient.getErrorCode(), "failed to insert data to es: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void insertDoc(String summaryIndexName, String docJson, String id) {
        RestHighLevelClient esClient = ESClient.getESClient();
        try {
            esClient.index(new IndexRequest(summaryIndexName).type("_doc").id(id).source(docJson, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new KDException(ESClient.getErrorCode(), "failed to insert data to es: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void insertBatchDocs(String summaryIndexName, List<Map<String, Object>> batchSummaryDocs) {
        if (batchSummaryDocs == null) {
            throw new IllegalArgumentException("param batchSummaryDocs is null");
        }
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        batchSummaryDocs.forEach(x -> bulkRequest.add(new IndexRequest(summaryIndexName).type("_doc").source(x, XContentType.JSON), (Object)RequestOptions.DEFAULT));
        RestHighLevelClient esClient = ESClient.getESClient();
        BulkResponse bulkResponse = null;
        try {
            bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(ESClient.getErrorCode(), "failed to insert batch data to es: " + e.getMessage(), (Throwable)e);
        }
        if (bulkResponse.hasFailures()) {
            for (BulkItemResponse resp : bulkResponse.getItems()) {
                if (!resp.isFailed()) continue;
                LOG.error("failed to insert summary doc: " + resp.getFailureMessage());
            }
        }
    }

    public static RestHighLevelClient getESClient() {
        Map<String, String> configMap = ESClient.getServerConfig(SERVER_REGION);
        String httpport = configMap.get(SERVER_HTTP_PORT);
        String port = httpport == null ? configMap.get(SERVER_PORT) : httpport;
        String userName = configMap.get(SERVER_USERNAME);
        String pwd = configMap.get(SERVER_PW);
        String ip = configMap.get(SERVER_IP);
        return CLIENT_CACHE_MAP.computeIfAbsent(ip + port, i -> {
            String password = pwd;
            if (userName != null && password != null) {
                password = Encrypters.decode((String)password);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, Integer.parseInt(port))}).setHttpClientConfigCallback(arg_0 -> ESClient.lambda$null$1((CredentialsProvider)credentialsProvider, arg_0)));
            }
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, Integer.parseInt(port), "http")}));
        });
    }

    public static Map<String, String> getServerConfig(String region) {
        String password;
        String username;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new KDException(ESClient.getErrorCode(), new Object[]{key + " the audit service is not configured."});
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(ESClient.getErrorCode(), key + " configuration resolution error.", (Throwable)e);
        }
        String ipStr = prop.getProperty(SERVER_IP);
        if (StringUtils.isEmpty((CharSequence)ipStr)) {
            throw new KDException(ESClient.getErrorCode(), new Object[]{key + " configuration error: ip can't be empty."});
        }
        result.put(SERVER_IP, ipStr.trim().toLowerCase(Locale.ENGLISH));
        String portStr = prop.getProperty(SERVER_PORT);
        if (StringUtils.isEmpty((CharSequence)portStr)) {
            throw new KDException(ESClient.getErrorCode(), new Object[]{key + " configuration error: port can't be empty."});
        }
        result.put(SERVER_PORT, portStr.trim().toLowerCase(Locale.ENGLISH));
        String httpPortStr = prop.getProperty(SERVER_HTTP_PORT);
        if (!StringUtils.isEmpty((CharSequence)httpPortStr)) {
            result.put(SERVER_HTTP_PORT, httpPortStr.trim().toLowerCase(Locale.ENGLISH));
        }
        if ((username = prop.getProperty(SERVER_USERNAME)) != null) {
            result.put(SERVER_USERNAME, username);
        }
        if ((password = prop.getProperty(SERVER_PW)) != null) {
            result.put(SERVER_PW, password);
        }
        String batchSize = prop.getProperty(SERVER_BATCH_SIZE, String.valueOf(1000));
        result.put(SERVER_BATCH_SIZE, batchSize);
        String enableStr = prop.getProperty(SERVER_ENABLE, "true");
        result.put(SERVER_ENABLE, enableStr.trim().toLowerCase(Locale.ENGLISH));
        String indexStr = prop.getProperty(SERVER_INDEX, region);
        result.put(SERVER_INDEX, indexStr.trim().toLowerCase(Locale.ENGLISH));
        String clusterNameStr = prop.getProperty(SERVER_CLUSTERNAME, "elasticsearch");
        result.put(SERVER_CLUSTERNAME, clusterNameStr);
        String totalFieldsStr = prop.getProperty(SERVER_TOTAL_FIELDS, String.valueOf(8000));
        result.put(SERVER_TOTAL_FIELDS, totalFieldsStr);
        String shardsNumberStr = prop.getProperty(SERVER_SHARDS_NUMBER, String.valueOf(2));
        result.put(SERVER_SHARDS_NUMBER, shardsNumberStr);
        String replicasNumberStr = prop.getProperty(SERVER_REPLICAS_NUMBER, String.valueOf(1));
        result.put(SERVER_REPLICAS_NUMBER, replicasNumberStr);
        return result;
    }

    public static Map<String, Integer> getIndexSettings() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        Map<String, String> configMap = ESClient.getServerConfig(SERVER_REGION);
        result.put("index.mapping.total_fields.limit", Integer.valueOf(configMap.get(SERVER_TOTAL_FIELDS)));
        result.put("number_of_replicas", Integer.valueOf(configMap.get(SERVER_REPLICAS_NUMBER)));
        result.put("number_of_shards", Integer.valueOf(configMap.get(SERVER_SHARDS_NUMBER)));
        return result;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$null$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

