/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class ESConnectHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ESConnectHelper.class);
    private static final String ES = "ES";
    private static Cache<String, ESConnectStatus> ES_CONNECT_CACHE = CacheBuilder.newBuilder().recordStats().expireAfterAccess(1L, TimeUnit.HOURS).build();
    protected static RequestOptions DEFAULT_REQUEST_OPTIONS = null;
    private static volatile ESConnectStatus temp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConnecting() {
        try {
            Map<String, String> configMap = ESClient.getServerConfig("audit");
            String httpPort = configMap.get("httpport");
            String port = httpPort == null ? configMap.get("port") : httpPort;
            String ip = configMap.get("ip");
            String key = Joiner.on((char)'_').join((Object)ES, (Object)ip, new Object[]{port});
            ESConnectStatus ES_LINK_STATUS = (ESConnectStatus)ES_CONNECT_CACHE.getIfPresent((Object)key);
            if (ES_LINK_STATUS != null && !ES_LINK_STATUS.isExpire()) return ES_LINK_STATUS.getConnectStatus();
            Class<ESConnectHelper> clazz = ESConnectHelper.class;
            synchronized (ESConnectHelper.class) {
                ES_LINK_STATUS = (ESConnectStatus)ES_CONNECT_CACHE.getIfPresent((Object)key);
                if (ES_LINK_STATUS != null && !ES_LINK_STATUS.isExpire()) return ES_LINK_STATUS.getConnectStatus();
                ES_LINK_STATUS = ESConnectHelper.tryConnectESAndCacheStatus(key);
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return ES_LINK_STATUS.getConnectStatus();
            }
        }
        catch (Exception e) {
            log.error("es connect fail;", e);
            return false;
        }
    }

    private static ESConnectStatus tryConnectESAndCacheStatus(String key) {
        try {
            SearchRequest request = new SearchRequest(new String[]{key});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(1);
            request.source(searchSourceBuilder);
            request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            ESClient.getESClient().search(request, DEFAULT_REQUEST_OPTIONS);
            temp = new ESConnectStatus(true, 1L, TimeUnit.HOURS);
        }
        catch (Exception e) {
            log.error("es connect fail;", e);
            temp = new ESConnectStatus(false, 10L, TimeUnit.MINUTES);
        }
        ES_CONNECT_CACHE.put((Object)key, (Object)temp);
        return temp;
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(0x40000000));
        DEFAULT_REQUEST_OPTIONS = builder.build();
        temp = null;
    }

    public static class ESConnectStatus {
        private Boolean connectStatus;
        private long createTime;
        private long expireTime;

        public ESConnectStatus(Boolean linkStatus, long duration, TimeUnit timeUnit) {
            this.connectStatus = linkStatus;
            this.createTime = System.nanoTime();
            this.expireTime = this.createTime + timeUnit.toNanos(duration);
        }

        public boolean isExpire() {
            return System.nanoTime() > this.expireTime;
        }

        public Boolean getConnectStatus() {
            return this.connectStatus;
        }
    }
}

