/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.fel.common.StringUtils;

public class ESDateUtils {
    private static final SimpleDateFormat ES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String TIME_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static String formatUTCDateFormat(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(TIME_FORMAT_ISO8601));
    }

    public static String formatUTCDateFormat(Date date, String datePattern) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(datePattern));
    }

    public static Date parseUTCDate(String date) {
        if (StringUtils.isEmpty(date)) {
            throw new IllegalArgumentException("param date is empty");
        }
        try {
            Pattern pattern = Pattern.compile("[0-9]*");
            if (pattern.matcher(date).matches()) {
                date = ES_DATE_FORMAT.format(Long.parseLong(date));
            }
            return ES_DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            throw new KDBizException("string:" + date + " can not be parsed to date");
        }
    }

    static {
        ES_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

