/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.common.CustOperationContexts;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.auditlog.LogTransactionType;
import kd.fi.bcm.common.json.JacksonUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class LogESHelper {
    private static final Set<String> EXISTING_INDICES = Collections.synchronizedSet(new HashSet(16));
    private static Map<String, LogTransactionType> transactionLogTypes;
    private static Map<String, String> metaEntityTransactionTypeMap;

    private LogESHelper() {
    }

    public static Map<String, LogTransactionType> getTransactionLogTypes() {
        return transactionLogTypes;
    }

    public static Map<String, String> getMetaEntityTransactionTypeMap() {
        return metaEntityTransactionTypeMap;
    }

    public static String getOperateType(String formId) {
        Map.Entry type = transactionLogTypes.entrySet().stream().filter(e -> ((LogTransactionType)e.getValue()).getMetaEntities().contains(formId)).findFirst().orElseGet(() -> null);
        return type != null ? (String)type.getKey() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAuditDetailIndex(String summaryIndexName, String dataIndexName) {
        if (LogESHelper.isIndexNotExists(dataIndexName) || LogESHelper.isIndexNotExists(summaryIndexName)) {
            ErrorCode errorCode = ESClient.getErrorCode();
            synchronized (errorCode) {
                Map<String, Integer> settingsMap = ESClient.getIndexSettings();
                RestHighLevelClient esClient = ESClient.getESClient();
                if (LogESHelper.isIndexNotExists(dataIndexName)) {
                    ESClient.createIndex(esClient, dataIndexName, settingsMap);
                    String dataMapping = LogESHelper.getResourceFileAsString("esmapping/cm/audit_data.json");
                    ESClient.createIndexMapping(esClient, dataIndexName, "_doc", dataMapping);
                    EXISTING_INDICES.add(dataIndexName);
                }
                if (LogESHelper.isIndexNotExists(summaryIndexName)) {
                    ESClient.createIndex(esClient, summaryIndexName, settingsMap);
                    String summaryMapping = LogESHelper.getResourceFileAsString("esmapping/cm/audit_summary.json");
                    ESClient.createIndexMapping(esClient, summaryIndexName, "_doc", summaryMapping);
                    EXISTING_INDICES.add(summaryIndexName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOpLogIndex(String indexName) {
        if (LogESHelper.isIndexNotExists(indexName)) {
            ErrorCode errorCode = ESClient.getErrorCode();
            synchronized (errorCode) {
                Map<String, Integer> settingsMap = ESClient.getIndexSettings();
                RestHighLevelClient esClient = ESClient.getESClient();
                if (LogESHelper.isIndexNotExists(indexName)) {
                    ESClient.createIndex(esClient, indexName, settingsMap);
                    String dataMapping = LogESHelper.getResourceFileAsString("esmapping/op_log.json");
                    ESClient.createIndexMapping(esClient, indexName, "_doc", dataMapping);
                    EXISTING_INDICES.add(indexName);
                }
            }
        }
    }

    private static boolean isIndexNotExists(String indexName) {
        RestHighLevelClient esClient;
        return !EXISTING_INDICES.contains(indexName) && !ESClient.isIndexExist(esClient = ESClient.getESClient(), indexName);
    }

    public static String getTransactionLogTypeConfigurationJson() {
        return LogESHelper.getResourceFileAsString("bcm/log_transaction_type.json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResourceFileAsString(String resourceFilePath) {
        try (InputStream summaryInputStream = LogESHelper.class.getClassLoader().getResourceAsStream(resourceFilePath);){
            String string = IOUtils.toString((InputStream)summaryInputStream, (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ESClient.getErrorCode(), new Object[]{"resource file:" + resourceFilePath + " read error."});
        }
    }

    public static Map<String, Object> buildAuditSummaryDoc(String traceId, String eventId, String hostIp, String operateType, String operateData, String userId, String userName, String cube) {
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("traceId", traceId);
        data.put("eventId", eventId);
        data.put("ip", "[0:0:0:0:0:0:0:1]".equals(hostIp) ? "127.0.0.1" : hostIp);
        data.put("operateType", operateType);
        data.put("operateData", operateData);
        data.put("operateTime", new Date());
        data.put("userId", userId);
        data.put("userName", userName);
        data.put("cubeNumber", cube);
        OperationContext context = OperationContext.get();
        if (Objects.nonNull(context)) {
            data.put("appId", context.getAppId());
            data.put("formId", CustOperationContexts.decideTargetFormId(context));
            data.put("opMethod", context.getOpMethod());
            data.put("opKey", context.getOpKey());
        }
        return data;
    }

    static {
        metaEntityTransactionTypeMap = new HashMap<String, String>(16);
        String json = LogESHelper.getTransactionLogTypeConfigurationJson();
        List<LogTransactionType> typeList = JacksonUtils.fromJson(json, new TypeReference<List<LogTransactionType>>(){});
        transactionLogTypes = typeList.stream().collect(Collectors.toMap(x -> x.getKey(), x -> x));
        transactionLogTypes.values().forEach(x -> {
            if (!CollectionUtils.isEmpty(x.getMetaEntities())) {
                x.getMetaEntities().forEach(t -> metaEntityTransactionTypeMap.put((String)t, x.getShowName()));
            } else if (StringUtils.isNotEmpty((CharSequence)x.getKey())) {
                metaEntityTransactionTypeMap.put(x.getKey(), x.getShowName());
            }
        });
    }
}

