/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.auditlog;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.auditlog.ESConnectHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OpLogHelper {
    private static final Log LOG = LogFactory.getLog(OpLogHelper.class);
    public static final String CACHE_KEY = "bcm_logsetting-OpLogHelper";
    private static LoadingCache<String, Map<String, Pair<Boolean, Integer>>> accidCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, Pair<Boolean, Integer>>>(){

        public Map<String, Pair<Boolean, Integer>> load(String accId) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)OpLogHelper.class.getName(), (String)"bcm_oplog_management", (String)"sourcekey,subsourcekey,enable,opcategory", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")}, null);){
                if (dataSet.isEmpty()) {
                    Map<String, Pair<Boolean, Integer>> map = Collections.emptyMap();
                    return map;
                }
                HashMap<String, Pair<Boolean, Integer>> result = new HashMap<String, Pair<Boolean, Integer>>(16);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    result.put((String)buildKey.apply(row.getString("sourcekey"), row.getString("subsourcekey")), new Pair<Boolean, Integer>(row.getBoolean("enable"), row.getInteger("opcategory")));
                }
                HashMap<String, Pair<Boolean, Integer>> hashMap = result;
                return hashMap;
            }
        }
    });
    private static volatile BiFunction<String, String, String> buildKey = (x, y) -> String.format("%s_%s", x, y);

    public static synchronized int getOpCategory(String sourceKey, String subSourceKey) {
        try {
            Pair opInfo = (Pair)((Map)accidCache.get((Object)RequestContext.get().getAccountId())).get(buildKey.apply(sourceKey, subSourceKey));
            return Objects.nonNull(opInfo) ? (Integer)opInfo.p2 : 0;
        }
        catch (ExecutionException e) {
            LOG.error("op_log failed:" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static synchronized boolean checkEventEnable(String sourceKey, String subSourceKey) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{sourceKey, subSourceKey})) {
            LOG.warn(String.format("not allowed event param is empty: sourceKey=%s, subSourceKey=%s", sourceKey, subSourceKey));
            return false;
        }
        try {
            Pair opInfo = (Pair)((Map)accidCache.get((Object)RequestContext.get().getAccountId())).get(buildKey.apply(sourceKey, subSourceKey));
            if (Objects.nonNull(opInfo)) {
                return (Boolean)opInfo.p1;
            }
            return false;
        }
        catch (ExecutionException e) {
            LOG.error("op_log failed:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static synchronized boolean checkModelEnable(String modelNumber, String sourceKey, String subSourceKey) {
        Map logConfigMap = GlobalCacheServiceHelper.getOrLoadFromCommonCache(CACHE_KEY, OpLogHelper::queryLogSetting);
        Map map = (Map)logConfigMap.get(modelNumber);
        if (map == null) {
            return false;
        }
        String needCheckKey = null;
        try {
            Pair opInfo = (Pair)((Map)accidCache.get((Object)RequestContext.get().getAccountId())).get(buildKey.apply(sourceKey, subSourceKey));
            if (!Objects.nonNull(opInfo)) {
                return false;
            }
            needCheckKey = String.valueOf(opInfo.p2);
        }
        catch (ExecutionException e) {
            LOG.error("op_log failed:" + e.getMessage(), (Throwable)e);
            return false;
        }
        if (needCheckKey == null) {
            return false;
        }
        if (!map.containsKey(needCheckKey)) {
            return false;
        }
        if (!((Boolean)map.get(needCheckKey)).booleanValue()) {
            return false;
        }
        return ESConnectHelper.isConnecting();
    }

    private static Map<String, Map<String, Boolean>> queryLogSetting() {
        String selectProperties = "model.number,transactionlogsetting,transactionlogsetting.isenable,transactionlogsetting.type";
        DynamicObject[] dataSet = BusinessDataServiceHelper.load((String)"bcm_logsetting", (String)selectProperties, null);
        if (dataSet == null) {
            return Maps.newHashMap();
        }
        HashMap<String, Map<String, Boolean>> logConfig = new HashMap<String, Map<String, Boolean>>(dataSet.length);
        Arrays.stream(dataSet).forEach(x -> {
            if (x != null && !StringUtils.isBlank((CharSequence)x.getString("model.number"))) {
                HashMap curModelConfigMap = new HashMap(8);
                logConfig.put(x.getString("model.number"), curModelConfigMap);
                DynamicObjectCollection doc = x.getDynamicObjectCollection("transactionlogsetting");
                doc.forEach(y -> {
                    if (y != null && !StringUtils.isBlank((CharSequence)y.getString("type"))) {
                        curModelConfigMap.put(y.getString("type"), y.getBoolean("isenable"));
                    }
                });
            }
        });
        return logConfig;
    }
}

