/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.bizrule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class BizRuleServiceHelper {
    public static List<ScriptInfo> getDefImportScript(String modelNumber) {
        return (List)ThreadCache.get((Object)("getDefImportScript->" + modelNumber), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add("model.number", "=", modelNumber);
            qf.add("iscommon", "=", true);
            qf.add("defaultimport", "=", true);
            qf.add(new QFilter("deletestatus", "=", (Object)false));
            qf.add("status", "=", "1");
            if (ThreadCache.exists((Object)"exclude_rule_id")) {
                qf.add("id", "!=", ThreadCache.get((Object)"exclude_rule_id", () -> 0L));
            }
            ArrayList list = new ArrayList(6);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_bizruleentity", (String)"name,content", (QFilter[])qf.toArray()).values().forEach(r -> {
                if (StringUtils.isNotEmpty((String)r.getString("content"))) {
                    list.add(new SimpleScriptInfo(r.getString("name") + ".js", r.getString("content")));
                }
            });
            return list;
        });
    }

    public static String getImportScript(String modelNumber, String ... rules) {
        StringBuilder script = new StringBuilder();
        QFBuilder qf = new QFBuilder();
        qf.add("model.number", "=", modelNumber);
        qf.add("iscommon", "=", true);
        qf.add("defaultimport", "=", false);
        qf.add(new QFilter("deletestatus", "=", (Object)false));
        qf.add("status", "=", "1");
        qf.add("number", "in", Lists.newArrayList((Object[])rules));
        BusinessDataServiceHelper.loadFromCache((String)"bcm_bizruleentity", (String)"content", (QFilter[])qf.toArray()).values().forEach(r -> {
            if (StringUtils.isNotEmpty((String)r.getString("content"))) {
                if (script.length() > 0) {
                    script.append("\n");
                }
                script.append(r.getString("content"));
            }
        });
        return script.toString();
    }

    public static Collection<DynamicObject> getBizRule(String modelNumber, Consumer<QFBuilder> filter, String ... processes) {
        ArrayList<Long> processIds = new ArrayList<Long>(processes.length);
        for (String process : processes) {
            processIds.add(MemberReader.findProcessMemberByNum(modelNumber, process).getId());
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model.number", "=", modelNumber);
        qf.add("bizrule.status", "=", "1");
        qf.add("bizrule.runstatus", "!=", String.valueOf(BizRuleRunStatusEnum.ADDED.getIndex()));
        qf.add("member", "in", processIds);
        qf.add(new QFilter("bizrule.deletestatus", "=", (Object)false));
        if (filter != null) {
            filter.accept(qf);
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_bizrulealloprocess", (String)"bizrule.id,bizrule.content,bizrule.executetype", (QFilter[])qf.toArray(), (String)"member,execsort asc").values();
    }

    public static String getBizRuleBaseInfo(long ruleId) {
        DynamicObject dyna = BizRuleServiceHelper.getBizRuleObject(ruleId);
        return "rule(" + dyna.getString("number") + "|" + dyna.getString("name") + ")";
    }

    public static String getBizRuleNum(long ruleId) {
        return BizRuleServiceHelper.getBizRuleObject(ruleId).getString("number");
    }

    public static String getBizRuleName(long ruleId) {
        return BizRuleServiceHelper.getBizRuleObject(ruleId).getString("name");
    }

    private static DynamicObject getBizRuleObject(long ruleId) {
        return GlobalCacheServiceHelper.getOrLoadNode("BizRuleInfo-" + ruleId, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleId, (String)"bcm_bizruleentity", (String)"number,name");
            return dyna;
        });
    }
}

