/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public class BcmThreadCache
implements AutoCloseable {
    private static final ThreadLocal<BcmThreadCache> btc = ThreadLocals.create(BcmThreadCache::new);
    private Map<String, Map<String, Map<Long, IDNumberTreeNode>>> memNodes = new HashMap<String, Map<String, Map<Long, IDNumberTreeNode>>>();
    private Map<String, Map<String, Map<String, IDNumberTreeNode>>> numberToMemNodes = new HashMap<String, Map<String, Map<String, IDNumberTreeNode>>>();
    private Map<Object, Map<Object, Map<Object, Object>>> threeLevel = new HashMap<Object, Map<Object, Map<Object, Object>>>();
    private Map<Object, Map<Object, Map<Object, Map<Object, Object>>>> fourLevel = new HashMap<Object, Map<Object, Map<Object, Map<Object, Object>>>>();
    private Map<Object, Map<Object, Map<Object, Map<Object, Map<Object, Object>>>>> fiveLevel = new HashMap<Object, Map<Object, Map<Object, Map<Object, Map<Object, Object>>>>>();

    public static BcmThreadCache current() {
        return btc.get();
    }

    public static <T> T get(Object key1, Object key2, Object key3, CacheLoader<T> loader) {
        Map map2 = BcmThreadCache.current().threeLevel.computeIfAbsent(key1, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key2, k -> new HashMap());
        return (T)map1.computeIfAbsent(key3, k -> loader.load());
    }

    public static <T> T get(Object key1, Object key2, Object key3, Object key4, CacheLoader<T> loader) {
        Map map3 = BcmThreadCache.current().fourLevel.computeIfAbsent(key1, k -> new HashMap());
        Map map2 = map3.computeIfAbsent(key2, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key3, k -> new HashMap());
        return (T)map1.computeIfAbsent(key4, k -> loader.load());
    }

    public static <T> T get(Object key1, Object key2, Object key3, Object key4, Object key5, CacheLoader<T> loader) {
        Map map4 = BcmThreadCache.current().fiveLevel.computeIfAbsent(key1, k -> new HashMap());
        Map map3 = map4.computeIfAbsent(key2, k -> new HashMap());
        Map map2 = map3.computeIfAbsent(key3, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key4, k -> new HashMap());
        return (T)map1.computeIfAbsent(key5, k -> loader.load());
    }

    public static IDNumberTreeNode findNodeById(String modelNum, String dimnum, long id) {
        Map mnodes = BcmThreadCache.current().memNodes.computeIfAbsent(modelNum, k -> new HashMap());
        Map nodes = mnodes.computeIfAbsent(dimnum, k -> new HashMap());
        return nodes.computeIfAbsent(id, k -> MemberReader.findMemberById(modelNum, DimEntityNumEnum.getEntieyNumByNumber(dimnum), (Long)id));
    }

    public static IDNumberTreeNode findMemberByNum(String modelNum, String dimNumber, String memNum) {
        Map mnodes = BcmThreadCache.current().numberToMemNodes.computeIfAbsent(modelNum, k -> new HashMap());
        Map nodes = mnodes.computeIfAbsent(dimNumber, k -> new HashMap());
        return nodes.computeIfAbsent(memNum, k -> MemberReader.findMemberByNumber(modelNum, dimNumber, memNum));
    }

    @Override
    public void close() throws Exception {
        this.memNodes = null;
        this.numberToMemNodes = null;
        this.fourLevel = null;
        this.fiveLevel = null;
    }
}

