/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.RequestContextUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class DimMemberCacheClean
implements AutoCloseable {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(true, DimMemberCacheClean.class);
    private static final ThreadLocal<DimMemberCacheClean> threadLocals = ThreadLocals.create(DimMemberCacheClean::new);
    private RequestContext context;
    private String modelNum;
    private Set<String> dimKeys = new HashSet<String>(16);
    private boolean isFixKey;

    private static DimMemberCacheClean current() {
        return threadLocals.get();
    }

    public static void setCacheParams(String modelNum, String dimKey, boolean isFixKey) {
        DimMemberCacheClean memberCache = DimMemberCacheClean.current();
        memberCache.modelNum = modelNum;
        memberCache.dimKeys.add(dimKey);
        memberCache.isFixKey = isFixKey;
        memberCache.context = RequestContext.get();
        threadLocals.set(memberCache);
    }

    @Override
    public void close() throws Exception {
        this.reloadMemberCache();
    }

    private void reloadMemberCache() {
        if (this.context == null || StringUtils.isEmpty(this.modelNum) || this.dimKeys.isEmpty()) {
            log.error("reloadDimensionCache fail,params is null.");
            return;
        }
        this.dimKeys.forEach(dimKey -> {
            try {
                RequestContextUtil.runWithCtx(this.context, c -> {
                    String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(this.modelNum, dimKey);
                    SyncCacheUtil.updateAppCacheTime(cacheKey);
                    if (SyncCacheUtil.isIncrementCache(dimKey)) {
                        log.error(String.format("reloadDimensionCache start,model number:%s,cache key:%s", this.modelNum, cacheKey));
                        GlobalCacheServiceHelper.reloadLocalCache(this.modelNum, DimEntityNumEnum.getNumberByEntieyNum(dimKey));
                    } else if (this.isFixKey) {
                        CacheGenFactory.getDimMemberCacheCache().invalidateByKey(cacheKey);
                    } else {
                        CacheGenFactory.getDimMemberCacheCache().invalidateStartsWithKey(cacheKey);
                    }
                });
            }
            catch (Exception ex) {
                log.error(String.format("reloadDimensionCache fail,model number:%s,caused by:%s", this.modelNum, ThrowableHelper.toString(ex)));
            }
        });
        threadLocals.remove();
    }
}

