/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import java.util.Locale;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bcm.common.cache.DimMemberCacheClean;
import kd.fi.bcm.common.cache.ICache;
import kd.fi.bcm.common.cache.LocalCacheHelper;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.cache.strategy.MemberQueryStrategy;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class GlobalCacheServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(GlobalCacheServiceHelper.class);

    public static String getOrCreateCacheKey() {
        return (String)ThreadCache.get((Object)"cache_node_prefix", () -> DBServiceHelper.genStringId());
    }

    private static String packKey(String prefix, String key) {
        return prefix + "|" + key;
    }

    public static <T> T getOrLoadFromCommonCache(String key, ILoader<T> loader) {
        return CacheGenFactory.getCommonCache().getOrLoad(key, loader);
    }

    public static <T> T getOrLoadNode(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase(Locale.ENGLISH)), loader);
    }

    public static <T> T getOrLoadNodeFixKey(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(key.toLowerCase(Locale.ENGLISH), loader);
    }

    public static <T> T getIfPresent(String key) {
        return CacheGenFactory.getTemporaryCache().getIfPresent(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase(Locale.ENGLISH)));
    }

    public static void invalidateAllCurrentCache(String processId) {
        CacheGenFactory.getTemporaryCache().invalidateStartsWithKey(processId);
    }

    public static void invalidateCacheByKey(String key) {
        CacheGenFactory.getTemporaryCache().invalidateByKey(key);
    }

    public static <T> T getImmutableTemplateModelOn(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemplateModelReadCache().getOrLoad(key, loader);
    }

    public static void invalidateTemplateModel(String key) {
        CacheGenFactory.getTemplateModelReadCache().invalidateByKey(key);
    }

    public static <T> T getOrLoadAboutDim(String modelNum, String key, ILoader<T> loader) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, key);
        return CacheGenFactory.getDimMemberCacheCache().getOrLoad(cacheKey, loader);
    }

    public static void invalidateAboutDim(String modelNum, String key) {
        DimMemberCacheClean.setCacheParams(modelNum, key, true);
        GlobalCacheServiceHelper.clearEntityBizAndNameRecord(modelNum, key);
    }

    public static void invalidateAllAboutDim(String modelNum, String key) {
        DimMemberCacheClean.setCacheParams(modelNum, key, false);
        GlobalCacheServiceHelper.clearEntityBizAndNameRecord(modelNum, key);
    }

    public static void invalidateAllAboutDimByFixedKey(String key) {
        CacheGenFactory.getDimMemberCacheCache().invalidateStartsWithKey(key);
    }

    public static String packAboutDimCacheKey(String modelNum, String key) {
        return modelNum + "|" + key;
    }

    private static void clearEntityBizAndNameRecord(String modelNum, String key) {
        if (DimEntityNumEnum.ENTITY.getNumber().equals(key) || "bcm_entitymembertree".equals(key)) {
            CacheGenFactory.getDimMemberCacheCache().invalidateByKey(GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, "bcm_entitymembertree_biz_change_record"));
            CacheGenFactory.getDimMemberCacheCache().invalidateByKey(GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, "bcm_entitymembertree_name_change_record"));
        }
    }

    public static void invalidateAnyCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            CacheGenFactory.getDimMemberCacheCache().invalidateAll();
            log.info(String.format("GlobalCacheServiceHelper clear all cache trace id:%s", RequestContext.get().getTraceId()));
        } else if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            CacheGenFactory.getTemplateModelReadCache().invalidateAll();
        } else if (CacheTypeEnum.CommonCache == cacheType) {
            CacheGenFactory.getCommonCache().invalidateAll();
        } else {
            log.info(String.format("GlobalCacheServiceHelper clear all cache other trace id:%s", RequestContext.get().getTraceId()));
            CacheGenFactory.getDimMemberCacheCache().invalidateAll();
            CacheGenFactory.getTemplateModelReadCache().invalidateAll();
            CacheGenFactory.getCommonCache().invalidateAll();
            CacheGenFactory.getTemporaryCache().invalidateAll();
            LocalCacheHelper.clear();
        }
    }

    public static void replaceCache(CacheTypeEnum cacheType, String cacheKey, Object value) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            CacheGenFactory.getDimMemberCacheCache().replaceCache(cacheKey, value);
        } else if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            CacheGenFactory.getTemplateModelReadCache().replaceCache(cacheKey, value);
        } else if (CacheTypeEnum.CommonCache == cacheType) {
            CacheGenFactory.getCommonCache().replaceCache(cacheKey, value);
        } else {
            CacheGenFactory.getTemporaryCache().replaceCache(cacheKey, value);
        }
    }

    public static ICache getCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            return CacheGenFactory.getDimMemberCacheCache();
        }
        if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            return CacheGenFactory.getTemplateModelReadCache();
        }
        if (CacheTypeEnum.CommonCache == cacheType) {
            return CacheGenFactory.getCommonCache();
        }
        if (CacheTypeEnum.TemporaryCache == cacheType) {
            return CacheGenFactory.getTemporaryCache();
        }
        if (CacheTypeEnum.BizStatusCache == cacheType) {
            return CacheGenFactory.getBizStatusCache();
        }
        if (CacheTypeEnum.TemplateAlternateFloatCache == cacheType) {
            return CacheGenFactory.getTemplateAlternateFloatCache();
        }
        throw new RuntimeException(String.format("not support cache type %s", cacheType == null ? "null" : cacheType.toString()));
    }

    public static ICache getCommonCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.CommonCache);
    }

    public static ICache getDimMemberCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.DimMemberCache);
    }

    public static ICache getBizStatusCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.BizStatusCache);
    }

    public static <T> T getOrLoadChkCheckCache(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad("chkcheckcache_" + key.toLowerCase(Locale.ENGLISH), loader);
    }

    public static void reloadLocalCache(String modelNum, String dimNum) {
        log.startWatch();
        String entityName = DimEntityNumEnum.getEntieyNumByNumber(dimNum);
        GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityName, () -> MemberQueryStrategy.getStrategy(entityName, dimNum).getAllNodes(modelNum));
        log.errorEnd(String.format("reloadLocalCache end. modelNum::%s, dimNum:: %s", modelNum, dimNum));
    }

    public static interface ILoader<T> {
        public T load();
    }
}

