/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.MemberPropMamanger;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.ToStringHelper;

public class IDNumberTreeNode
implements Cloneable {
    private Long id;
    private String number;
    private Long copyFromId;
    private IDNumberTreeNode parent;
    private List<IDNumberTreeNode> shareNodes;
    private List<IDNumberTreeNode> children;
    private String aggOprt;
    private int dSeq;
    private int level;
    private Tuple<Long, String, String> dim;
    private StorageTypeEnum storageType;
    private boolean isLeaf;
    private Pair<Long, String> model;
    private String longNumber = "";
    private String currency;
    private Map<String, Object> properties = null;
    private Map<String, String> localeNames;
    private Map<Integer, List<IDNumberTreeNode>> childType2AllChildren = new HashMap<Integer, List<IDNumberTreeNode>>(16);
    public static final IDNumberTreeNode NotFoundTreeNode = new IDNumberTreeNode(-1L, "not found", "", -1, -1, null, null, false, null, -1L, "");

    public IDNumberTreeNode(Long id, String number, String aggOprt, int dSeq, int level, Tuple<Long, String, String> dim, StorageTypeEnum storageType, boolean isLeaf, Pair<Long, String> model, Long copyFromId, String name) {
        this.id = id;
        this.number = number;
        this.copyFromId = copyFromId;
        this.aggOprt = aggOprt;
        this.dSeq = dSeq;
        this.level = level;
        this.dim = dim;
        this.storageType = storageType == StorageTypeEnum.UNSHARE ? null : storageType;
        this.isLeaf = isLeaf;
        this.model = model;
        this.initLocaleNames(name);
    }

    public final void initLocaleNames(String name) {
        this.localeNames = new ConcurrentHashMap<String, String>(4);
        this.localeNames.put(RequestContext.get().getLang().name(), name);
    }

    public String getName() {
        String langName = RequestContext.getOrCreate().getLang().name();
        if (this.dim == null || StringUtils.isEmpty((String)((String)this.dim.p3))) {
            return this.localeNames.get(langName);
        }
        if (!this.localeNames.containsKey(langName)) {
            DynamicObject entityNode = BusinessDataServiceHelper.loadSingle((String)((String)this.dim.p3), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.id)});
            String localeName = entityNode != null && entityNode.getLocaleString("name").getLocaleValue() != null ? entityNode.getLocaleString("name").getLocaleValue() : this.localeNames.values().iterator().next();
            this.localeNames.put(langName, localeName);
        }
        return this.localeNames.get(langName);
    }

    public String getAggOprt() {
        return this.aggOprt;
    }

    public int getdSeq() {
        return this.dSeq;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDimNumber() {
        return (String)this.dim.p2;
    }

    public Long getDimId() {
        return (Long)this.dim.p1;
    }

    public StorageTypeEnum getStorageType() {
        return this.storageType == null ? StorageTypeEnum.UNSHARE : this.storageType;
    }

    public boolean isShare() {
        return StorageTypeEnum.isShare(this.getStorageType());
    }

    public Long getModelId() {
        return (Long)this.model.p1;
    }

    public String getModelNumber() {
        return (String)this.model.p2;
    }

    public void addChild(IDNumberTreeNode id) {
        if (this.children == null) {
            this.children = new ArrayList<IDNumberTreeNode>(16);
        }
        this.children.add(id);
    }

    public void addShareNode(IDNumberTreeNode shareNode) {
        if (this.shareNodes == null) {
            this.shareNodes = new ArrayList<IDNumberTreeNode>(10);
        }
        this.shareNodes.add(shareNode);
    }

    public List<IDNumberTreeNode> getShareNodes() {
        return this.shareNodes == null ? new ArrayList(1) : this.shareNodes;
    }

    public void setChildren(List<IDNumberTreeNode> nodeList) {
        this.children = nodeList;
    }

    public IDNumberTreeNode getParent() {
        return this.parent;
    }

    public void setParent(IDNumberTreeNode parent) {
        this.parent = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public Long getCopyfromId() {
        return this.copyFromId;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public String getSearchTxt() {
        return this.number.toLowerCase(Locale.ENGLISH) + "," + this.getName().toLowerCase(Locale.ENGLISH);
    }

    public void setAggOprt(String aggOprt) {
        this.aggOprt = aggOprt;
    }

    public void setdSeq(int dSeq) {
        this.dSeq = dSeq;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
    }

    public IDNumberTreeNode getBaseTreeNode() {
        if (this != NotFoundTreeNode && this.copyFromId != 0L) {
            return MemberReader.findMemberById(this.getModelNumber(), MemberReader.getEntityNumberByDim(this.getModelNumber(), this.getDimNumber()), this.copyFromId);
        }
        return this;
    }

    public List<IDNumberTreeNode> getAllChildren(int childType) {
        List<IDNumberTreeNode> nodes = this.childType2AllChildren.get(childType);
        if (nodes == null) {
            nodes = new ArrayList<IDNumberTreeNode>(16);
            this.addAllChildren(childType, nodes);
            this.childType2AllChildren.put(childType, nodes);
        }
        return nodes;
    }

    private void addAllChildren(int childType, List<IDNumberTreeNode> nodes) {
        if (this.children == null) {
            IDNumberTreeNode baseNode;
            if ((childType == 3 || childType == 4) && this.isShare() && this.getCopyfromId() != 0L && NotFoundTreeNode != (baseNode = this.getBaseTreeNode())) {
                baseNode.addAllChildren(childType, nodes);
            }
            return;
        }
        for (IDNumberTreeNode node : this.children) {
            switch (childType) {
                case 0: {
                    nodes.add(node);
                    break;
                }
                case 1: {
                    if (node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 2: {
                    if (!node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 3: {
                    this.walkAllChildrenIncludeShareNode(false, node, nodes, childType);
                    break;
                }
                case 4: {
                    this.walkAllChildrenIncludeShareNode(true, node, nodes, childType);
                    break;
                }
            }
            if (node.isLeaf()) continue;
            node.addAllChildren(childType, nodes);
        }
    }

    private void walkAllChildrenIncludeShareNode(boolean includeNotLeaf, IDNumberTreeNode node, List<IDNumberTreeNode> nodes, int childType) {
        if (node.isLeaf) {
            if (!node.isShare()) {
                nodes.add(node);
            } else {
                IDNumberTreeNode base = MemberReader.findMemberById(this.getModelNumber(), MemberReader.getEntityNumberByDim(this.getModelNumber(), this.getDimNumber()), node.getCopyfromId());
                if (base.isLeaf()) {
                    nodes.add(node);
                } else {
                    if (includeNotLeaf) {
                        nodes.add(node);
                    }
                    base.addAllChildren(childType, nodes);
                }
            }
        } else if (includeNotLeaf) {
            nodes.add(node);
        }
    }

    public List<IDNumberTreeNode> getAllChildren() {
        return this.getAllChildren(0);
    }

    public Set<Long> getAllChildrenIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        List<IDNumberTreeNode> allChildren = this.getAllChildren();
        for (IDNumberTreeNode node : allChildren) {
            if (node.getId() <= 0L) continue;
            ids.add(node.getId());
        }
        return ids;
    }

    public List<IDNumberTreeNode> getBrother() {
        ArrayList<IDNumberTreeNode> ids = new ArrayList<IDNumberTreeNode>(10);
        if (this.getParent() == null) {
            return ids;
        }
        for (IDNumberTreeNode node : this.getParent().getChildren()) {
            if (node.getId().equals(this.id)) continue;
            ids.add(node);
        }
        return ids;
    }

    public IDNumberTreeNode parent(Object id) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getId().equals(id)) {
            return this.parent;
        }
        return this.parent.parent(id);
    }

    public IDNumberTreeNode closest(Object id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.closest(id);
    }

    public List<IDNumberTreeNode> getChildren() {
        if (this.isShare() && this.isLeaf && this.copyFromId != 0L) {
            return this.getBaseTreeNode().getChildren();
        }
        return this.children == null ? new ArrayList(0) : this.children;
    }

    public Set<Long> getChildrenIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (this.children != null) {
            for (IDNumberTreeNode node : this.children) {
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public Set<Long> getStorageAllChildrenIds(int childType, boolean isStorage) {
        HashSet<Long> ids = new HashSet<Long>(16);
        List<IDNumberTreeNode> allChildren = this.getAllChildren(childType);
        if (allChildren != null) {
            for (IDNumberTreeNode node : allChildren) {
                if (isStorage && node.getCopyfromId() != 0L) {
                    ids.add(node.getCopyfromId());
                    continue;
                }
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public String getLongNumber() {
        if (StringUtils.isEmpty((String)this.longNumber)) {
            this.longNumber = this.getParent() != null ? this.getParent().getLongNumber() + "!" + this.number : this.number;
        }
        return this.longNumber;
    }

    public boolean isInternalCompany() {
        if (this.dim == null || !DimEntityNumEnum.INTERCOMPANY.getNumber().equals(this.dim.p2) || this.getParent() == null) {
            return false;
        }
        String parentNum = this.getParent().getNumber();
        if ("ICEntity".equals(parentNum) || "ICOEntity".equals(parentNum)) {
            return "ICEntity".equals(parentNum);
        }
        return this.getParent().isInternalCompany();
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getVirtualEntity() {
        if (!PresetConstant.ENTITY_DIM.equals(this.dim.p2)) {
            throw new RuntimeException(String.format("not support get VirtualEntity on %s dimension.", this.dim.p2));
        }
        if (this.getParent() == null) {
            throw new RuntimeException(String.format("member{%s} not has Parent,can't constuct VirtualEntity.", this.number));
        }
        return this.getParent().getNumber() + "_" + this.getNumber();
    }

    public String getVirtualEntityForSearch() {
        if (this.getParent() == null) {
            return "";
        }
        return this.getParent().getNumber() + "_" + this.getNumber();
    }

    public String getCustomPropVal(String dimPropName) {
        return MemberPropMamanger.getMemberPropMamanger(this.getDimId(), this.getDimNumber(), this.getModelNumber()).getPropVal(this.id, dimPropName);
    }

    public <T> T loadAndConsumerProp(String selectField, Function<DynamicObject, T> consumer) {
        String entity = MemberReader.getEntityNumberByDim(this.getModelNumber(), this.getDimNumber());
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getId(), (String)entity, (String)selectField);
        return consumer.apply(dyna);
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public IDNumberTreeNode clone() {
        IDNumberTreeNode o = null;
        try {
            o = (IDNumberTreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException("IDNumberTreeNode clone not support");
        }
        return o;
    }

    public String toString() {
        return ToStringHelper.reflectionToString(this);
    }

    public String getParent_SonNumber() {
        if (!PresetConstant.ENTITY_DIM.equals(this.getDimNumber()) || this.getParent() == null) {
            return this.getNumber();
        }
        return this.getParent().getNumber() + "_" + this.getNumber();
    }

    public int getYear() {
        try {
            return Integer.parseInt(this.number.substring(2));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getPeriodLastDay() {
        try {
            int month = Integer.parseInt((String)this.getProperty("expmonth"));
            int day = Integer.parseInt((String)this.getProperty("expday"));
            return month * 100 + day;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public Map<Integer, List<IDNumberTreeNode>> getChildType2AllChildren() {
        return this.childType2AllChildren;
    }
}

