/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.fi.bcm.common.cache.LocalCacheNullValue;

public class LocalCacheHelper {
    private static final LocalCacheNullValue NULL = new LocalCacheNullValue();
    private static final CacheConfigInfo cacheConfig = new CacheConfigInfo();

    public static void put(String key, Object content) {
        if (content != null) {
            CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "bcm", cacheConfig).put(key, content);
        }
    }

    public static <T> T get(String key, Class<T> clazz) {
        return (T)CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "bcm", cacheConfig).get(key);
    }

    public static <T> T get(String key, CacheLoader<T> loader) {
        return (T)ThreadCache.get((Object)key, () -> {
            Object value = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "bcm", cacheConfig).get(key);
            if (value == null) {
                value = loader.load();
                LocalCacheHelper.put(key, value == null ? NULL : value);
            } else if (NULL == value) {
                value = null;
            }
            return value;
        });
    }

    public static void clear() {
        CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "bcm", cacheConfig).clear();
    }

    static {
        cacheConfig.setTimeout(30);
        cacheConfig.setMaxItemSize(100000);
        cacheConfig.setTimeToLive(false);
    }
}

