/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.entity.EntityBizRecord;
import kd.fi.bcm.common.cache.entity.EntityChangeRecord;
import kd.fi.bcm.common.cache.entity.EntityNameRecord;
import kd.fi.bcm.common.cache.entity.EntityQueryHelper;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.cache.strategy.MemberQueryStrategy;
import kd.fi.bcm.common.enums.CommonModelEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.ThrowableHelper;

public class MemberReader {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MemberReader.class);

    public static Map<Long, IDNumberTreeNode> getAllNodeFromCache(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getId2Node();
    }

    public static Map<String, Map<String, IDNumberTreeNode>> getAllNodeByNumberFromCache(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getNumber2Node();
    }

    public static Map<String, Map<String, IDNumberTreeNode>> getAllNodeByUpperCaseNumberFromCache(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getUpperCaseNumber2Node();
    }

    public static Map<String, Map<String, List<IDNumberTreeNode>>> getAllNodeByNumber2ShareNodeFromCache(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getNumber2ShareNode();
    }

    public static Map<Long, List<EntityBizRecord>> getAllEntBizRecFromCache(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, "bcm_entitymembertree_biz_change_record", () -> EntityQueryHelper.queryBizChangeRecord(modelNum));
    }

    public static Map<Long, List<EntityNameRecord>> getAllEntNameRecFromCache(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, "bcm_entitymembertree_name_change_record", () -> EntityQueryHelper.queryNameChangeRecord(modelNum));
    }

    public static Map<Long, EntityChangeRecord> getEntChangeRecs(String modelNum, Collection<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return new HashMap<Long, EntityChangeRecord>(1);
        }
        Map<Long, List<EntityBizRecord>> allEntBizRecs = MemberReader.getAllEntBizRecFromCache(modelNum);
        Map<Long, List<EntityNameRecord>> allEntNameRecs = MemberReader.getAllEntNameRecFromCache(modelNum);
        return entityIds.stream().collect(Collectors.toMap(k -> k, v -> {
            List<EntityNameRecord> entityNameRecords;
            List<EntityBizRecord> entityBizRecords = (List<EntityBizRecord>)allEntBizRecs.get(v);
            if (entityBizRecords == null) {
                entityBizRecords = Collections.emptyList();
            }
            if ((entityNameRecords = (List<EntityNameRecord>)allEntNameRecs.get(v)) == null) {
                entityNameRecords = Collections.emptyList();
            }
            return new EntityChangeRecord((Long)v, entityBizRecords, entityNameRecords);
        }, (e1, e2) -> e2));
    }

    public static Map<Long, List<EntityBizRecord>> getEntBizRecs(String modelNum, Collection<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return new HashMap<Long, List<EntityBizRecord>>(1);
        }
        Map<Long, List<EntityBizRecord>> allEntBizRecs = MemberReader.getAllEntBizRecFromCache(modelNum);
        return entityIds.stream().collect(Collectors.toMap(k -> k, v -> {
            List entityBizRecords = (List)allEntBizRecs.get(v);
            if (entityBizRecords == null) {
                entityBizRecords = Collections.emptyList();
            }
            return entityBizRecords;
        }, (e1, e2) -> e2));
    }

    public static List<EntityBizRecord> getEntBizRecs(String modelNum, Long entityId) {
        List<EntityBizRecord> reulst = Collections.emptyList();
        if (entityId == null) {
            return reulst;
        }
        reulst = MemberReader.getAllEntBizRecFromCache(modelNum).get(entityId);
        if (reulst == null) {
            reulst = Collections.emptyList();
        }
        return reulst;
    }

    public static Map<Long, List<EntityNameRecord>> getEntNameRecs(String modelNum, Collection<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return new HashMap<Long, List<EntityNameRecord>>(1);
        }
        Map<Long, List<EntityNameRecord>> allEntNameRecs = MemberReader.getAllEntNameRecFromCache(modelNum);
        return entityIds.stream().collect(Collectors.toMap(k -> k, v -> {
            List entityNameRecords = (List)allEntNameRecs.get(v);
            if (entityNameRecords == null) {
                entityNameRecords = Collections.emptyList();
            }
            return entityNameRecords;
        }, (e1, e2) -> e2));
    }

    public static List<EntityNameRecord> getEntNameRecs(String modelNum, Long entityId) {
        List<EntityNameRecord> reulst = Collections.emptyList();
        if (entityId == null) {
            return reulst;
        }
        reulst = MemberReader.getAllEntNameRecFromCache(modelNum).get(entityId);
        if (reulst == null) {
            reulst = Collections.emptyList();
        }
        return reulst;
    }

    public static EntityNameRecord getEntNameRecs(String modelNum, Long entityId, Long yearId, Long periodId) {
        Date[] datePair;
        Date lastDate;
        Long modelId = MemberReader.findModelIdByNum(modelNum);
        List<EntityNameRecord> entNameRecs = MemberReader.getEntNameRecs(modelNum, entityId);
        if (CollectionUtils.isEmpty(entNameRecs)) {
            return null;
        }
        IDNumberTreeNode yearNumberNode = MemberReader.findFyMemberById(modelId, yearId);
        if (IDNumberTreeNode.NotFoundTreeNode == yearNumberNode) {
            return null;
        }
        IDNumberTreeNode periodNumberNode = MemberReader.findPeriodMemberById(modelId, periodId);
        if (IDNumberTreeNode.NotFoundTreeNode != periodNumberNode && (lastDate = (datePair = PeriodUtils.calcStartAndEndDate((long)modelId, yearNumberNode.getNumber(), periodNumberNode.getNumber()))[1]) != null) {
            for (EntityNameRecord entNameRec : entNameRecs) {
                if (!MemberReader.isBetweenDateRange(entNameRec.getNameEffDate(), entNameRec.getNameExpDate(), lastDate)) continue;
                return entNameRec;
            }
        }
        return null;
    }

    private static boolean isBetweenDateRange(Date start, Date end, Date date) {
        start.setHours(0);
        start.setMinutes(0);
        start.setSeconds(0);
        if (end != null) {
            end.setHours(0);
            end.setMinutes(0);
            end.setSeconds(0);
        }
        return start.compareTo(date) <= 0 && (end == null || end.compareTo(date) >= 0);
    }

    public static Collection<IDNumberTreeNode> getAllNodeByDimNum(String dimNum, String modelNum) {
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        if ("bcm_userdefinedmembertree".equals(entityNumber)) {
            return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber + "_" + dimNum, () -> MemberQueryStrategy.getStrategy(entityNumber, dimNum).getAllNodes(modelNum)).getId2Node().values();
        }
        return MemberReader.getAllNodeFromCache(entityNumber, modelNum).values();
    }

    public static boolean isEffective(Date expPeriodDate, DynamicObjectCollection bizchangerds) {
        for (DynamicObject dyn : bizchangerds) {
            Date effdate = dyn.getDate("bizeffdate");
            Date expdate = dyn.getDate("bizexpdate");
            if (effdate.after(expPeriodDate) || expdate != null && expdate.before(expPeriodDate)) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, IDNumberTreeNode> getAllNodeFromCache(String entityNumber, Object modelId) {
        String modelNum = MemberReader.findModelNumberById(modelId);
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getId2Node();
    }

    public static IDNumberTreeNode findMemberById(String modelNum, String entityNumber, Long memberId) {
        if (memberId == null) {
            return IDNumberTreeNode.NotFoundTreeNode;
        }
        IDNumberTreeNode member = MemberReader.getAllNodeFromCache(entityNumber, modelNum).get(memberId);
        if (member == null && !"bcm_definedpropertyvalue".equals(entityNumber)) {
            Map<Long, IDNumberTreeNode> dimVariables = MemberReader.getDimVariables(entityNumber);
            member = dimVariables.get(memberId);
        }
        if (member == null) {
            member = IDNumberTreeNode.NotFoundTreeNode;
            log.warn(String.format("model:%s,entityNumber:%s,member:%s is not found.", modelNum, entityNumber, memberId));
        }
        return member;
    }

    public static IDNumberTreeNode findMemberById(long modelId, String entityNumber, Long memberId) {
        return MemberReader.findMemberById(MemberReader.findModelNumberById(modelId), entityNumber, memberId);
    }

    @SDKMark
    public static IDNumberTreeNode findMemberByNumber(String modelNum, String dimNum, String number) {
        Optional<IDNumberTreeNode> dimVariable;
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        IDNumberTreeNode member = MemberReader.searchMemberByNumber(modelNum, entityNumber, dimNum, number);
        if (member == null && !"bcm_definedpropertyvalue".equals(entityNumber) && (dimVariable = MemberReader.getDimVariables(entityNumber).values().stream().filter(d -> d.getNumber().equalsIgnoreCase(number)).findFirst()).isPresent()) {
            return dimVariable.get();
        }
        if (member == null) {
            log.error(String.format("model:%s,dimNum:%s,number:%s is not found.", modelNum, dimNum, number));
            member = IDNumberTreeNode.NotFoundTreeNode;
        }
        return member;
    }

    public static IDNumberTreeNode findMemberByIgnorCaseNumber(String modelNum, String dimNum, String number) {
        Set cacheNullMap = (Set)ThreadCache.get((Object)"cache-Null", () -> new HashSet(16));
        String cacheKey = Joiner.on((char)'|').join((Object)modelNum, (Object)dimNum, new Object[]{number});
        if (cacheNullMap.contains(cacheKey)) {
            return null;
        }
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        Map<String, IDNumberTreeNode> dimMap = MemberReader.getAllNodeByUpperCaseNumberFromCache(entityNumber, modelNum).get(dimNum);
        IDNumberTreeNode node = null;
        if (dimMap != null) {
            node = dimMap.get(number.toUpperCase(Locale.ENGLISH));
        }
        if (node == null) {
            cacheNullMap.add(cacheKey);
            log.error(String.format("model:%s,dim:%s,member:%s is not found.", modelNum, dimNum, number));
        }
        return node;
    }

    private static IDNumberTreeNode searchMemberByNumber(String modelNum, String entityNumber, String dimNum, String number) {
        Map<String, IDNumberTreeNode> number2Node = MemberReader.getAllNodeByNumberFromCache(entityNumber, modelNum).get(dimNum);
        if (number2Node == null) {
            log.error(String.format("model:%s,dim:%s,member:%s is not found.", modelNum, dimNum, number));
            return null;
        }
        return number2Node.get(number);
    }

    public static String findModelNumberById(Object id) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_number_" + id.toString(), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"number");
            if (dyna == null) {
                log.error(String.format("model id:%s is not found from cache.", id));
                dyna = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"number");
            }
            return dyna.getString("number");
        });
    }

    public static String findModelSNumberById(Object id) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_snumber_" + id.toString(), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"shownumber");
            return dyna.getString("shownumber");
        });
    }

    public static String findDMModelSNumberById(Object id) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_snumber_" + id.toString(), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id.toString()), (String)"fidm_model", (String)"number");
            return dyna.getString("number");
        });
    }

    public static Long findModelIdByNum(String number) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_id_2_number_" + number, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{number}).toArray());
            return dyna == null ? 0L : dyna.getLong("id");
        });
    }

    public static String findModelNumberByShowNum(String showNumber) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_shownumber_2_number_" + showNumber, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"number", (QFilter[])QFilter.of((String)"shownumber=?", (Object[])new Object[]{showNumber}).toArray());
            return dyna == null ? "" : dyna.getString("number");
        });
    }

    public static Long findModelIdByShowNum(String showNumber) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("model_number_2_id_" + showNumber, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])QFilter.of((String)"shownumber=?", (Object[])new Object[]{showNumber}).toArray());
            return dyna == null ? 0L : dyna.getLong("id");
        });
    }

    public static Date findModelBeginDate(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("getModelBeginDate-" + modelNum, () -> {
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,startfy,beginperiod,beginyearofmonth", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{modelNum}).toArray());
            if (model == null) {
                return null;
            }
            int firstYear = model.getInt("startfy") + 1997 - 1;
            int firstMonth = model.getInt("beginperiod");
            String beginYearType = model.getString("beginyearofmonth");
            if (FyEnum.PRE.index.equals(beginYearType)) {
                --firstYear;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, firstYear);
            cal.set(2, firstMonth - 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        });
    }

    public static IDNumberTreeNode findFyMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_fymembertree", membId);
    }

    public static IDNumberTreeNode findFyMemberById(Long modelId, Long membId) {
        return MemberReader.findMemberById(modelId, "bcm_fymembertree", membId);
    }

    public static IDNumberTreeNode findFyMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.FY_DIM, number);
    }

    public static IDNumberTreeNode findPeriodMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_periodmembertree", membId);
    }

    public static IDNumberTreeNode findPeriodMemberById(Long modelId, Long membId) {
        return MemberReader.findMemberById(modelId, "bcm_periodmembertree", membId);
    }

    public static IDNumberTreeNode findPeriodMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.PERIOD_DIM, number);
    }

    public static IDNumberTreeNode findScenaMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_scenemembertree", membId);
    }

    public static IDNumberTreeNode findScenaMemberById(Long modelId, Long membId) {
        return MemberReader.findMemberById(modelId, "bcm_scenemembertree", membId);
    }

    public static IDNumberTreeNode findScenaMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.SCENE_DIM, number);
    }

    public static IDNumberTreeNode findCurrencyMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_currencymembertree", membId);
    }

    public static IDNumberTreeNode findCurrencyMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.CURRENCY_DIM, number);
    }

    public static IDNumberTreeNode findEntityMemberById(Long modelId, Long membId) {
        return MemberReader.findMemberById(modelId, "bcm_entitymembertree", membId);
    }

    @SDKMark
    public static IDNumberTreeNode findEntityMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_entitymembertree", membId);
    }

    public static IDNumberTreeNode findEntityMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.ENTITY_DIM, number);
    }

    public static IDNumberTreeNode findProcessMemberById(String modelNum, Long membId) {
        return MemberReader.findMemberById(modelNum, "bcm_processmembertree", membId);
    }

    public static IDNumberTreeNode findProcessMemberByNum(String modelNum, String number) {
        return MemberReader.findMemberByNumber(modelNum, PresetConstant.PROCESS_DIM, number);
    }

    public static IDNumberTreeNode findMemberByLongNumber(String modelNum, String dimNum, String longNumber) {
        IDNumberTreeNode node = MemberReader.findMemberByPredicate(modelNum, dimNum, m -> longNumber.equals(m.getLongNumber()));
        return node == null ? IDNumberTreeNode.NotFoundTreeNode : node;
    }

    public static List<IDNumberTreeNode> findEntityMemberByPredicate(String modelNum, String number, Predicate<IDNumberTreeNode> pre) {
        IDNumberTreeNode baseNode = MemberReader.findMemberByNumber(modelNum, PresetConstant.ENTITY_DIM, number);
        ArrayList<IDNumberTreeNode> result = new ArrayList<IDNumberTreeNode>(5);
        if (pre.test(baseNode)) {
            result.add(baseNode);
        }
        if (baseNode.getShareNodes() != null) {
            for (IDNumberTreeNode shareNode : new ArrayList<IDNumberTreeNode>(baseNode.getShareNodes())) {
                if (!pre.test(shareNode)) continue;
                result.add(shareNode);
            }
        }
        return result;
    }

    public static IDNumberTreeNode findMemberByPredicate(String modelNum, String dimNum, Predicate<IDNumberTreeNode> pre) {
        Collection<IDNumberTreeNode> nodes = MemberReader.getAllNodeByDimNum(dimNum, modelNum);
        for (IDNumberTreeNode m : nodes) {
            if (!pre.test(m)) continue;
            return m;
        }
        return null;
    }

    public static void findMemberByConsumer(String modelNum, String dimNum, Consumer<IDNumberTreeNode> consumer) {
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        for (IDNumberTreeNode m : MemberReader.getAllNodeFromCache(entityNumber, modelNum).values()) {
            consumer.accept(m);
        }
    }

    public static boolean isExistMember(String modelNum, String dimNum, String member) {
        return MemberReader.findMemberByPredicate(modelNum, dimNum, p -> dimNum.equals(p.getDimNumber()) && member != null && member.equals(p.getNumber())) != null;
    }

    public static boolean isExistMemberById(String modelNum, String dimNum, Long memberId) {
        return memberId != null && MemberReader.findMemberByPredicate(modelNum, dimNum, p -> dimNum.equals(p.getDimNumber()) && memberId.equals(p.getId())) != null;
    }

    public static boolean isExistDimension(String modelNum, String dimNum) {
        return MemberReader.getDimensionShortNumber2NumberMap(modelNum).containsValue(dimNum);
    }

    public static boolean isExistAuditTrailDimension(String modelNum) {
        return MemberReader.isExistDimension(modelNum, PresetConstant.AUDITTRIAL_DIM);
    }

    public static boolean isExistAuditTrailDimension(long modelId) {
        return MemberReader.isExistDimension(MemberReader.findModelNumberById(modelId), PresetConstant.AUDITTRIAL_DIM);
    }

    public static boolean isExistChangeTypeDimension(String modelNum) {
        return MemberReader.isExistDimension(modelNum, PresetConstant.CHANGETYPE_DIM);
    }

    public static boolean isExistChangeTypeDimension(long modelId) {
        return MemberReader.isExistDimension(MemberReader.findModelNumberById(modelId), PresetConstant.CHANGETYPE_DIM);
    }

    public static boolean isDynamicStorageType(String modelNum, String dimNum, String memberNum) {
        IDNumberTreeNode member = MemberReader.findMemberByNumber(modelNum, dimNum, memberNum);
        return member == null ? false : member.getStorageType() == StorageTypeEnum.DYNAMIC;
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-number-short-" + modelNum, () -> {
            LinkedHashMap cacheMap = new LinkedHashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray(), (String)"dseq").values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum, Boolean isbcm) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-id-shortnumber2name-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            String entityname = isbcm != false ? "bcm_dimension" : "epm_dimension";
            BusinessDataServiceHelper.loadFromCache((String)entityname, (String)"id,number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("id") + e.getString("number")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, String> getDimensionNumber2nameMap(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-number-short2name" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber,name,id", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number") + ";" + e.getString("name") + ";" + e.getString("id")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, Integer> getMemberShortNum2Dseq(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-snumber-dseq-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"shortnumber, dseq", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getInt("dseq")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, Integer> getMemberNum2Dseq(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-number-dseq-" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number, dseq", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("number"), e.getInt("dseq")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, String> getMemberNumber2NameMap(long modelId, String dimNum) {
        return (Map)ThreadCache.get((Object)("mem-number-name-" + modelId + dimNum), () -> {
            HashMap cacheMap = new HashMap(64);
            BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber(dimNum), (String)"number,name", (QFilter[])new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dimension.number", "=", (Object)dimNum)).toArray()).values().forEach(e -> cacheMap.put(e.getString("number"), e.getString("name")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, String> getMemberNumber2SimpleNameMap(long modelId, String dimNum) {
        return (Map)ThreadCache.get((Object)("mem-number-simplename-" + modelId + dimNum), () -> {
            HashMap cacheMap = new HashMap(64);
            QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber(dimNum), (String)"number,name,simplename", (QFilter[])new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dimension.number", "=", (Object)dimNum)).toArray()).forEach(e -> cacheMap.put(e.getString("number"), e.getString("simplename") == null || e.getString("simplename").isEmpty() ? e.getString("name") : e.getString("simplename")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, Integer> getMemberNumber2SeqMap(long modelId, String dimNum) {
        HashMap cacheMap = new HashMap(64);
        BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber(dimNum), (String)"number,dseq", (QFilter[])new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dimension.number", "=", (Object)dimNum)).toArray()).values().forEach(e -> cacheMap.put(e.getString("number"), e.getInt("dseq")));
        return Collections.unmodifiableMap(cacheMap);
    }

    public static Map<String, Integer> getMemberNumber2LevelMap(long modelId, String dimNum) {
        HashMap cacheMap = new HashMap(64);
        BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber(dimNum), (String)"number,level", (QFilter[])new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dimension.number", "=", (Object)dimNum)).toArray()).values().forEach(e -> cacheMap.put(e.getString("number"), e.getInt("level")));
        return Collections.unmodifiableMap(cacheMap);
    }

    public static TreeNode filterTreeNodeUnique(TreeNode treeNode, Set<String> nums) {
        if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty()) {
            for (TreeNode child : treeNode.getChildren()) {
                if (!nums.add((String)child.getData())) {
                    child.setData((Object)("repeat_" + child.getData()));
                }
                MemberReader.filterTreeNodeUnique(child, nums);
            }
        }
        return treeNode;
    }

    public static List<TreeNode> preOrderTree(TreeNode root) {
        if (root == null) {
            return new ArrayList<TreeNode>(12);
        }
        Stack<Object> stack = new Stack<Object>();
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(12);
        stack.push(root);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            result.add(node);
            if (node.getChildren() == null || node.getChildren().isEmpty()) continue;
            for (int i = node.getChildren().size() - 1; i >= 0; --i) {
                stack.push(node.getChildren().get(i));
            }
        }
        return result;
    }

    public static Set<String> getDimensionProp(String modelNum, String dimNum) {
        long dimensionId = MemberReader.getDimensionIdByNum(MemberReader.findModelIdByNum(modelNum), dimNum);
        return DimPropList.getDimPropList(dimensionId).getPropList();
    }

    public static Long getDimensionIdByNum(long modelId, String dimNumber) {
        return (Long)((Map)MemberReader.getModelDimIDAndNumberMap((long)modelId).p2).get(dimNumber);
    }

    public static String getDimensionNumById(long dimId) {
        DynamicObject dimObj = MemberReader.getDimensionDynById(dimId);
        return dimObj != null ? dimObj.getString("number") : "";
    }

    public static String getDimensionNameById(long dimId) {
        DynamicObject dimObj = MemberReader.getDimensionDynById(dimId);
        return dimObj != null ? dimObj.getString("name") : "";
    }

    public static DynamicObject getDimensionDynById(long dimId) {
        try {
            return GlobalCacheServiceHelper.getOrLoadFromCommonCache("getDimensionDynById-" + dimId, () -> {
                if (QueryServiceHelper.exists((String)"bcm_dimension_ext", (Object)dimId)) {
                    return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension_ext");
                }
                return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension");
            });
        }
        catch (Exception ex) {
            log.error(String.format("getDimensionDynById[%s] error.", dimId) + ThrowableHelper.toString(ex));
            return null;
        }
    }

    public static Pair<Map<Long, String>, Map<String, Long>> getModelDimIDAndNumberMap(long modelId) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(MemberReader.findModelNumberById(modelId), "getDimensionId-Num", () -> {
            LinkedHashMap<Long, String> id2NumbMap = new LinkedHashMap<Long, String>(16);
            LinkedHashMap<String, Long> numb2IdMap = new LinkedHashMap<String, Long>(16);
            QFilter[] filter = new QFilter("model", "=", (Object)modelId).toArray();
            QueryServiceHelper.query((String)"bcm_dimension", (String)"number,id", (QFilter[])filter, (String)"dseq").forEach(e -> {
                id2NumbMap.put(e.getLong("id"), e.getString("number"));
                numb2IdMap.put(e.getString("number"), e.getLong("id"));
            });
            DynamicObject extDim = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id,number", (QFilter[])filter);
            if (extDim != null) {
                id2NumbMap.put(extDim.getLong("id"), extDim.getString("number"));
                numb2IdMap.put(extDim.getString("number"), extDim.getLong("id"));
            }
            return Pair.onePair(id2NumbMap, numb2IdMap);
        });
    }

    public static Map<String, String> getDimNumberMapNameById(long modelId) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(MemberReader.findModelNumberById(modelId), "getDimensionName-Num", () -> {
            LinkedHashMap map = new LinkedHashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"number, name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").forEach(e -> map.put(e.getString("number"), e.getString("name")));
            return map;
        });
    }

    public static Map<String, DynamicObject> getDimDyoByModelId(long modelId) {
        return (Map)ThreadCache.get((Object)("getDimDyoByModelId" + modelId), () -> {
            HashMap map = new HashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,membermodel,fieldmapped,issysdimension,shortnumber,dseq", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").forEach(e -> map.put(e.getString("number"), e));
            return map;
        });
    }

    public static Map<String, String> getUsetDefineDimNumberMapNameById(long modelId) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(MemberReader.findModelNumberById(modelId), "getUserDefinedDimensionName-Num", () -> {
            LinkedHashMap map = new LinkedHashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"number, name", (QFilter[])new QFilter("model", "=", (Object)modelId).and("issysdimension", "=", (Object)false).toArray(), (String)"dseq").forEach(e -> map.put(e.getString("number"), e.getString("name")));
            return map;
        });
    }

    public static Map<String, DataTypeEnum> getMemberDataType(long modelId, String entity, String dimNum) {
        return GlobalCacheServiceHelper.getOrLoadNode("getMemberDataType-Num" + modelId + dimNum, () -> {
            HashMap<String, DataTypeEnum> map = new HashMap<String, DataTypeEnum>();
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            if (StringUtils.isNotEmpty((String)dimNum)) {
                long dimId = MemberReader.getDimensionIdByNum(modelId, dimNum);
                filter.and("dimension", "=", (Object)dimId);
            }
            filter.and("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{DataTypeEnum.CURRENCY.index, DataTypeEnum.UNCURRENCY.index, DataTypeEnum.TXT.index, DataTypeEnum.DATETP.index, DataTypeEnum.PROPORTION.index, DataTypeEnum.ENUMTP.index}));
            String select = "dimension.number,number,datatype";
            if (!DimTypesEnum.DATASORT.getNumber().equals(dimNum)) {
                select = select + ",enumitem.datatype";
            }
            DynamicObjectCollection cols = QueryServiceHelper.query((String)entity, (String)select, (QFilter[])filter.toArray());
            for (DynamicObject dyn : cols) {
                DataTypeEnum dataType = DataTypeEnum.getDataTypeEnumByIndex(dyn.getString("datatype"));
                if (DataTypeEnum.getDataTypeEnumByIndex(dyn.getString("datatype")) == DataTypeEnum.ENUMTP) {
                    map.put(dyn.getString("dimension.number") + "_" + dyn.getString("number") + "_item", DataTypeEnum.getDataTypeEnumByIndex(dyn.getString("enumitem.datatype")));
                }
                map.put(dyn.getString("dimension.number") + "_" + dyn.getString("number"), dataType);
            }
            return map;
        });
    }

    public static Set<Long> change2BaseMember(String entity, Set<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashSet<Long>(0);
        }
        for (Long id : ids) {
            DynamicObject first = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_entitymembertree", (String)"model.id");
            if (first == null) continue;
            return MemberReader.change2BaseMember(first.getLong("model.id"), entity, ids);
        }
        return ids;
    }

    public static Long change2BaseMember(String modelNum, Long id) {
        IDNumberTreeNode node;
        if (id != null && (node = MemberReader.findEntityMemberById(modelNum, id)) != IDNumberTreeNode.NotFoundTreeNode) {
            if (node.getCopyfromId() != null && node.getCopyfromId() != 0L) {
                return node.getCopyfromId();
            }
            return node.getId();
        }
        return null;
    }

    public static Set<Long> change2BaseMember(long modelId, String entity, Set<Long> ids) {
        HashSet<Long> baseIds = new HashSet<Long>();
        long copyFromId = 0L;
        for (Long id : ids) {
            IDNumberTreeNode node = MemberReader.findMemberById(modelId, entity, id);
            if (node.isShare()) {
                copyFromId = node.getCopyfromId();
                if (copyFromId == 0L) continue;
                baseIds.add(copyFromId);
                continue;
            }
            baseIds.add(id);
        }
        return baseIds;
    }

    public static Set<String> change2MemberNumsById(long modelId, String entity, List<Long> ids) {
        int initialCapacity = ids != null ? ids.size() : 16;
        HashSet<String> baseNums = new HashSet<String>(initialCapacity);
        if (ids != null) {
            for (Long id : ids) {
                IDNumberTreeNode node = MemberReader.findMemberById(modelId, entity, id);
                baseNums.add(node.getNumber());
            }
        }
        return baseNums;
    }

    public static String getEntityNumberByDim(String modelNum, String dimensionNumber) {
        return DimEntityNumEnum.getEntieyNumByNumber(dimensionNumber);
    }

    public static boolean isBase(String modelNum, String dimNum, String child, String parent) {
        if (StringUtils.isEmpty((String)child) || StringUtils.isEmpty((String)parent)) {
            return false;
        }
        String entityNumber = MemberReader.getEntityNumberByDim(modelNum, dimNum);
        NodeList nodeList = GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, dimNum).getAllNodes(modelNum));
        Map<String, IDNumberTreeNode> mList = nodeList.getNumber2Node().get(dimNum);
        IDNumberTreeNode m = mList.get(child);
        IDNumberTreeNode p = mList.get(parent);
        if (m == null || p == null) {
            log.error(String.format("model:%s,dim:%s,child:%s,parent:%s is no found.", modelNum, dimNum, child, parent));
            return false;
        }
        if (m.isLeaf()) {
            return MemberReader.isBase(m, p);
        }
        return false;
    }

    private static boolean isBase(IDNumberTreeNode node, IDNumberTreeNode parent) {
        if (MemberReader.findParent(node, parent)) {
            return true;
        }
        if (node.getShareNodes() != null) {
            for (IDNumberTreeNode shareNode : node.getShareNodes()) {
                if (!MemberReader.findParent(shareNode, parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findParent(IDNumberTreeNode node, IDNumberTreeNode parent) {
        String[] parents = node.getLongNumber().split("!");
        for (int i = 0; i < parents.length - 1; ++i) {
            if (!parents[i].equals(parent.getNumber())) continue;
            return true;
        }
        return false;
    }

    private static boolean isChild(IDNumberTreeNode m, IDNumberTreeNode p) {
        if (m.getParent() == null) {
            return false;
        }
        if (m.getParent().equals(p)) {
            return true;
        }
        List<IDNumberTreeNode> shareNodes = m.getShareNodes();
        if (shareNodes != null && !shareNodes.isEmpty()) {
            for (IDNumberTreeNode shareNode : shareNodes) {
                if (!MemberReader.isChild(shareNode, p)) continue;
                return true;
            }
        }
        return MemberReader.isChild(m.getParent(), p);
    }

    public static Map<Long, IDNumberTreeNode> getDimVariables(String entityName) {
        TreeMap<Long, IDNumberTreeNode> nodes = new TreeMap<Long, IDNumberTreeNode>();
        if ("bcm_definedpropertyvalue".equals(entityName)) {
            return nodes;
        }
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("mr_getDimVariables_" + entityName, () -> {
            QFilter filter = new QFilter("model", "=", (Object)CommonModelEnum.DIMENSION_VAR.getModelId());
            filter.and(new QFilter("dimension", "=", (Object)CommonModelEnum.DIMENSION_VAR.getDimensionId()));
            filter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection docs = QueryServiceHelper.query((String)entityName, (String)"id,number,name,dseq,level,dimension", (QFilter[])filter.toArray(), (String)"dseq");
            HashMap<String, Tuple> dimMap = new HashMap<String, Tuple>(16);
            for (DynamicObject obj : docs) {
                Tuple dim = dimMap.compute(DimEntityNumEnum.getNumberByEntieyNum(entityName), (k, v) -> v == null ? Tuple.create(obj.getLong("dimension"), k, entityName) : v);
                IDNumberTreeNode node = new IDNumberTreeNode(obj.getLong("id"), obj.getString("number"), "", obj.getInt("dseq"), obj.getInt("level"), dim, StorageTypeEnum.DEFAULT, true, Pair.onePair(CommonModelEnum.DIMENSION_VAR.getModelId(), ""), 0L, obj.getString("name"));
                nodes.put(obj.getLong("id"), node);
            }
            return nodes;
        });
    }

    public static List<IDNumberTreeNode> getSomeNodeByDimNum(String dimNum, String modelNum, List<Long> memIds) {
        Collection<IDNumberTreeNode> allNodeByDimNum = MemberReader.getAllNodeByDimNum(dimNum, modelNum);
        return allNodeByDimNum.stream().filter(x -> memIds.contains(x.getId())).collect(Collectors.toList());
    }

    public static List<String> getNoMergeMembers(String modelNum, String dimNum) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, dimNum) + "-getNoMergeMembers";
        String entityName = DimEntityNumEnum.getEntieyNumByNumber(dimNum);
        if (!DimEntityNumEnum.isMergeDim(entityName)) {
            return new ArrayList<String>(16);
        }
        return GlobalCacheServiceHelper.getDimMemberCache().getOrLoad(cacheKey, () -> {
            long modelId = MemberReader.findModelIdByNum(modelNum);
            long dimId = MemberReader.getDimensionIdByNum(modelId, dimNum);
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            if (DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNum)) {
                filter.and(new QFilter("isparticipmerge", "=", (Object)false));
            } else {
                filter.and(new QFilter("ismerge", "=", (Object)false));
            }
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
            return QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toList());
        });
    }

    public static Set<String> getNoMergeMembersSet(String modelNum, String dimNum) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, dimNum) + "-getNoMergeMembersSet";
        String entityName = DimEntityNumEnum.getEntieyNumByNumber(dimNum);
        if (!DimEntityNumEnum.isMergeDim(entityName)) {
            return new HashSet<String>(16);
        }
        return GlobalCacheServiceHelper.getDimMemberCache().getOrLoad(cacheKey, () -> {
            long modelId = MemberReader.findModelIdByNum(modelNum);
            long dimId = MemberReader.getDimensionIdByNum(modelId, dimNum);
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            if (DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNum)) {
                filter.and(new QFilter("isparticipmerge", "=", (Object)false));
            } else {
                filter.and(new QFilter("ismerge", "=", (Object)false));
            }
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index));
            return QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toSet());
        });
    }

    public static Map<Long, DynamicObject> getDimeId2Dyn(Long modelId) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("dim-id-2-dimdyn" + modelId, () -> {
            LinkedHashMap cacheMap = new LinkedHashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"number, shortnumber, name, id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").forEach(e -> cacheMap.put(e.getLong("id"), e));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static class NodeList {
        private Map<Long, IDNumberTreeNode> id2Node;
        private Map<String, Map<String, IDNumberTreeNode>> number2Node;
        private Map<String, Map<String, List<IDNumberTreeNode>>> number2ShareNode;
        private Map<String, Map<String, IDNumberTreeNode>> upperCaseNumber2Node;

        public Map<Long, IDNumberTreeNode> getId2Node() {
            return this.id2Node;
        }

        public void setId2Node(Map<Long, IDNumberTreeNode> id2Node) {
            this.id2Node = id2Node;
        }

        public Map<String, Map<String, IDNumberTreeNode>> getNumber2Node() {
            return this.number2Node;
        }

        public void setNumber2Node(Map<String, Map<String, IDNumberTreeNode>> number2Node) {
            this.number2Node = number2Node;
        }

        public Map<String, Map<String, IDNumberTreeNode>> getUpperCaseNumber2Node() {
            if (CollectionUtils.isEmpty(this.upperCaseNumber2Node)) {
                this.initUpperCaseNumberCache();
            }
            return this.upperCaseNumber2Node;
        }

        private void initUpperCaseNumberCache() {
            if (this.number2Node != null) {
                this.upperCaseNumber2Node = new HashMap<String, Map<String, IDNumberTreeNode>>(this.number2Node.size());
                this.number2Node.entrySet().forEach(e -> {
                    HashMap v = new HashMap(((Map)e.getValue()).size());
                    ((Map)e.getValue()).entrySet().forEach(m -> {
                        IDNumberTreeNode cfr_ignored_0 = (IDNumberTreeNode)v.put(((String)m.getKey()).toUpperCase(Locale.ENGLISH), m.getValue());
                    });
                    this.upperCaseNumber2Node.put((String)e.getKey(), v);
                });
            } else {
                this.upperCaseNumber2Node = new HashMap<String, Map<String, IDNumberTreeNode>>(16);
            }
        }

        public Map<String, Map<String, List<IDNumberTreeNode>>> getNumber2ShareNode() {
            return this.number2ShareNode;
        }

        public void setNumber2ShareNode(Map<String, Map<String, List<IDNumberTreeNode>>> number2ShareNode) {
            this.number2ShareNode = number2ShareNode;
        }
    }
}

