/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EntityNameRecord
implements Serializable {
    public static final String CACHE_KEY = "bcm_entitymembertree_name_change_record";
    private static final long serialVersionUID = -6874519438112382860L;
    private Long id;
    private Map<String, String> localNames;
    private Map<String, String> localSimpleNames;
    private Date nameEffDate;
    private Date nameExpDate;

    public EntityNameRecord() {
    }

    public EntityNameRecord(Long id, String name, String simpleName, Date nameEffDate, Date nameExpDate) {
        this.id = id;
        this.nameEffDate = nameEffDate;
        this.nameExpDate = nameExpDate;
        String langName = RequestContext.getOrCreate().getLang().name();
        this.localNames = new ConcurrentHashMap<String, String>(4);
        this.localNames.put(langName, name);
        this.localSimpleNames = new ConcurrentHashMap<String, String>(4);
        this.localSimpleNames.put(langName, simpleName);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        String langName = RequestContext.getOrCreate().getLang().name();
        return this.localNames.computeIfAbsent(langName, k -> {
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"namechangerds.namerds", (QFilter[])new QFilter[]{new QFilter("namechangerds.id", "=", (Object)this.id)});
            String localeName = dyn != null && dyn.getString("namechangerds.namerds") != null ? dyn.getString("namechangerds.namerds") : this.localNames.values().iterator().next();
            return localeName;
        });
    }

    public String getSimpleName() {
        String langName = RequestContext.getOrCreate().getLang().name();
        return this.localSimpleNames.computeIfAbsent(langName, k -> {
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"namechangerds.simplenamerds", (QFilter[])new QFilter[]{new QFilter("namechangerds.id", "=", (Object)this.id)});
            String localeName = dyn != null && dyn.getString("namechangerds.simplenamerds") != null ? dyn.getString("namechangerds.simplenamerds") : this.localNames.values().iterator().next();
            return localeName;
        });
    }

    public Date getNameEffDate() {
        return this.nameEffDate;
    }

    public void setNameEffDate(Date nameEffDate) {
        this.nameEffDate = nameEffDate;
    }

    public Date getNameExpDate() {
        return this.nameExpDate;
    }

    public void setNameExpDate(Date nameExpDate) {
        this.nameExpDate = nameExpDate;
    }

    public String toString() {
        return "EntityNameRecord{id=" + this.id + ", localNames=" + this.localNames + ", localSimpleNames=" + this.localSimpleNames + ", nameEffDate=" + this.nameEffDate + ", nameExpDate=" + this.nameExpDate + '}';
    }
}

