/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.entity.EntityBizRecord;
import kd.fi.bcm.common.cache.entity.EntityNameRecord;

public class EntityQueryHelper {
    public static Map<Long, List<EntityBizRecord>> queryBizChangeRecord(String modelNum) {
        Long modelId = MemberReader.findModelIdByNum(modelNum);
        HashMap<Long, List> result = new HashMap<Long, List>(16);
        String sql = "select b.fid, a.fentityid, a.fchangetype, a.feffdate, a.fexpdate from t_bcm_entitybizrecord a inner join t_bcm_structofent b on b.fid=a.fid where b.fmodelid = ? order by A.fseq asc";
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"find_bizchange_bcm_entitymembertree", (DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{modelId});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                result.computeIfAbsent(row.getLong("fid"), k -> new LinkedList()).add(new EntityBizRecord(row.getLong("fentityid"), row.getString("fchangetype"), row.getDate("feffdate"), row.getDate("fexpdate")));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : result.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<Long, List<EntityNameRecord>> queryNameChangeRecord(String modelNum) {
        Long modelId = MemberReader.findModelIdByNum(modelNum);
        HashMap result = new HashMap(16);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,namechangerds.id,namechangerds.nameeffdate,namechangerds.nameexpdate,namechangerds.namerds, namechangerds.simplenamerds", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, (String)"namechangerds.seq asc");
        if (doc != null && !doc.isEmpty()) {
            doc.forEach(e -> {
                if (e.getLong("namechangerds.id") != 0L) {
                    result.computeIfAbsent(e.getLong("id"), k -> new LinkedList()).add(new EntityNameRecord(e.getLong("namechangerds.id"), e.getString("namechangerds.namerds"), e.getString("namechangerds.simplenamerds"), e.getDate("namechangerds.nameeffdate"), e.getDate("namechangerds.nameexpdate")));
                }
            });
        }
        for (Map.Entry entry : result.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }
}

