/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.localcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.localcache.AbstractLocalCache;
import kd.fi.bcm.common.enums.CacheTypeEnum;

public class DimMemberLocalCache
extends AbstractLocalCache {
    private static final CacheConfigInfo cacheConfig = new CacheConfigInfo();
    private final ConcurrentHashMap<String, ReentrantLock> entrantLocks = new ConcurrentHashMap(16);

    private DimMemberLocalCache(LocalMemoryCache cache) {
        super(cache);
    }

    public DimMemberLocalCache() {
        this(CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "bcm_$dimMemberCache", cacheConfig));
    }

    @Override
    public CacheTypeEnum getCacheType() {
        return CacheTypeEnum.DimMemberCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOrLoad(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        if (this.isExist(key)) {
            return super.getOrLoad(key, loader);
        }
        try {
            this.entrantLocks.computeIfAbsent(key, k -> new ReentrantLock()).lock();
            T t = super.getOrLoad(key, loader);
            return t;
        }
        finally {
            this.entrantLocks.get(key).unlock();
        }
    }

    static {
        cacheConfig.setTimeout(Integer.getInteger("dim_local_cache_time", 21600).intValue());
        cacheConfig.setMaxItemSize(500);
    }
}

