/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.localcache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.ICache;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class SyncCacheUtil {
    public static final String APP_BCM_TIME = "_bcmCT.";
    public static final String TIME_KEY = "#time#";

    private static IAppCache getAppTimeCache() {
        return AppCache.get((String)APP_BCM_TIME);
    }

    public static long getTimeFromAppCache(String key) {
        String timekey = key + TIME_KEY;
        String time = (String)SyncCacheUtil.getAppTimeCache().get(timekey, String.class);
        if (StringUtils.isNotEmpty((CharSequence)time)) {
            return Long.parseLong(time);
        }
        return 0L;
    }

    public static void updateAppCacheTime(String key) {
        String timekey = key + TIME_KEY;
        SyncCacheUtil.getAppTimeCache().put(timekey, (Object)System.currentTimeMillis());
    }

    public static long getTimeFromLocalCache(LocalMemoryCache cache, String key) {
        if (!cache.contains(TIME_KEY)) {
            return 0L;
        }
        HashMap timemap = (HashMap)cache.get(TIME_KEY);
        if (timemap == null) {
            return 0L;
        }
        return timemap.getOrDefault(key, 0L);
    }

    public static void updateLocalCacheTime(LocalMemoryCache cache, String key, long cacheTime) {
        HashMap value = cache.get(TIME_KEY);
        if (value == null) {
            value = new HashMap();
            cache.put(TIME_KEY, value);
        }
        ((HashMap)value).put(key, cacheTime);
    }

    public static long getTimeFromLocalCache(String key) {
        Map timeMap = (Map)CacheGenFactory.getDimMemberCacheCache().getIfPresent(TIME_KEY);
        if (timeMap == null) {
            return 0L;
        }
        return timeMap.getOrDefault(key, 0L);
    }

    public static void updateLocalCacheTime(String key, long cacheTime) {
        ICache cache = CacheGenFactory.getDimMemberCacheCache();
        HashMap<String, Long> timeMap = (HashMap<String, Long>)cache.getIfPresent(TIME_KEY);
        if (timeMap == null) {
            timeMap = new HashMap<String, Long>(16);
        }
        timeMap.put(key, cacheTime);
        cache.put(TIME_KEY, timeMap);
    }

    public static boolean isIncrementCache(String entityName) {
        return "bcm_icmembertree".equals(entityName);
    }

    public static void saveMemberCache(Long modelId, Long dimId, Set<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ArrayList members = new ArrayList(ids.size());
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        ids.forEach(id -> {
            DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membercacherecord");
            newObj.set("model", (Object)modelId);
            newObj.set("dimension", (Object)dimId);
            newObj.set("member", id);
            newObj.set("creator", (Object)userId);
            newObj.set("createtime", (Object)now);
            members.add(newObj);
        });
        SaveServiceHelper.save((DynamicObject[])members.toArray(new DynamicObject[0]));
    }

    public static DynamicObjectCollection queryMemberCache(Long modelId, Long dimId, String cacheKey) {
        long cacheTime = SyncCacheUtil.getTimeFromLocalCache(cacheKey);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("dimension", "=", (Object)dimId));
        Date modifyTime = new Date(cacheTime - 3600000L);
        filter.and(new QFilter("createtime", ">=", (Object)modifyTime));
        return QueryServiceHelper.query((String)"bcm_membercacherecord", (String)"member", (QFilter[])filter.toArray());
    }

    public static void removeMemberCache(String modelNum, String dimNum) {
        QFilter filter = new QFilter("model.number", "=", (Object)modelNum);
        filter.and(new QFilter("dimension.number", "=", (Object)dimNum));
        filter.and(new QFilter("createtime", "<=", (Object)new Date(System.currentTimeMillis() - 172800000L)));
        DeleteServiceHelper.delete((String)"bcm_membercacherecord", (QFilter[])filter.toArray());
    }
}

