/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.prop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;

public class DimPropList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> fieldMap = new HashMap<String, String>(4);
    private Map<String, Long> fielIddMap = new HashMap<String, Long>(4);
    private Map<String, String> fieldNameMap = new HashMap<String, String>(4);
    private Map<String, String> mapToField = new HashMap<String, String>(4);
    private long dimensionId;

    public DimPropList(long dimensionId) {
        this.dimensionId = dimensionId;
        this.loadData();
    }

    private void loadData() {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_definedproperty", (String)"id,number,name,propertyn", (QFilter[])new QFilter("dimension.id", "=", (Object)this.dimensionId).toArray()).values().forEach(e -> {
            this.fieldMap.put(e.getString("number"), e.getString("propertyn"));
            this.mapToField.put(e.getString("propertyn"), e.getString("number"));
            this.fieldNameMap.put(e.getString("number"), e.getString("name"));
            this.fielIddMap.put(e.getString("number"), e.getLong("id"));
        });
    }

    public Set<String> getPropList() {
        return this.fieldMap.keySet();
    }

    public String getFieldMapped(String propName) {
        return this.fieldMap.get(propName);
    }

    public String getFieldName(String propName) {
        return this.fieldNameMap.get(propName);
    }

    public Long getFieldId(String propName) {
        return this.fielIddMap.get(propName);
    }

    public static DimPropList getDimPropList(long dimensionId) {
        return GlobalCacheServiceHelper.getOrLoadNode("DimPropList:" + dimensionId, () -> new DimPropList(dimensionId));
    }

    public Map<String, String> getMapToField() {
        return this.mapToField;
    }

    public Map<String, String> getFieldNameMap() {
        return this.fieldNameMap;
    }
}

