/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.prop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.cache.prop.MemberPropValList;
import kd.fi.bcm.common.util.QFBuilder;

public class MemberPropMamanger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long dimensionId;
    private Map<Long, MemberPropValList> memberPropMap = new HashMap<Long, MemberPropValList>(16);

    public MemberPropMamanger(long dimensionId, String dimNumber, String modelNumber) {
        this.dimensionId = dimensionId;
        this.load(dimNumber, modelNumber);
    }

    public Map<Long, MemberPropValList> getMemberPropMap() {
        return this.memberPropMap;
    }

    public static MemberPropMamanger getMemberPropMamanger(long dimensionId, String dimNumber, String modelNumber) {
        return GlobalCacheServiceHelper.getOrLoadNode("MemberPropMamanger:" + dimensionId, () -> new MemberPropMamanger(dimensionId, dimNumber, modelNumber));
    }

    private void load(String dimNumber, String modelNumber) {
        QFBuilder qf = new QFBuilder();
        qf.add("dimension.id", "=", this.dimensionId);
        QFBuilder orqf = new QFBuilder();
        DefinedPropertyUtil.getDefinedProperty(this.dimensionId).forEach(f -> orqf.or((String)f, "!=", 0L));
        qf.and(orqf);
        QueryServiceHelper.query((String)MemberReader.getEntityNumberByDim(modelNumber, dimNumber), (String)DefinedPropertyUtil.getSelector(this.dimensionId), (QFilter[])qf.toArray()).forEach(m -> this.memberPropMap.put(m.getLong("id"), new MemberPropValList(this.dimensionId, (DynamicObject)m)));
    }

    public String getPropVal(long memberId, String dimProp) {
        MemberPropValList vlist = this.memberPropMap.get(memberId);
        DimPropList plist = DimPropList.getDimPropList(this.dimensionId);
        String fieldName = plist.getFieldMapped(dimProp);
        if (vlist != null && fieldName != null) {
            return vlist.getPropVal(fieldName);
        }
        return null;
    }
}

