/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.cache.strategy.IMemberQuery;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BatchProcessHelper;
import kd.fi.bcm.common.util.CollectionUtil;

public abstract class AbstractMemberQuery
implements IMemberQuery {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(true, AbstractMemberQuery.class);
    public static final String EMPTY_STR = "";

    protected List<String> getProperties() {
        return new ArrayList<String>(16);
    }

    protected String getSelectFields() {
        String selectFields = "id,number,name,dimension.number,dimension,model,level,issysmember,aggoprt,parent,copyfrom,dseq,storagetype,isleaf";
        if (!this.getProperties().isEmpty()) {
            selectFields = selectFields + "," + String.join((CharSequence)",", this.getProperties());
        }
        return selectFields;
    }

    protected void addProperties(IDNumberTreeNode node, DynamicObject obj, Map<String, IDNumberTreeNode> number2Node) {
        this.getProperties().forEach(pro -> {
            if (!pro.equals("assostoremem")) {
                node.addProperty((String)pro, obj.get(pro));
            } else if (obj.getLong("assostoremem") != 0L) {
                node.addProperty((String)pro, obj.getLong("assostoremem"));
            }
        });
    }

    protected void addQFilter(QFilter filter) {
    }

    protected void addTimeFilter(String modelNum, QFilter filter) {
    }

    protected String orderBy() {
        return null;
    }

    protected String getAgg(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return EMPTY_STR;
        }
        String agg = obj.getString("aggoprt");
        if (StringUtils.isEmpty((String)agg) || "0".equals(agg)) {
            return EMPTY_STR;
        }
        return AggOprtEnum.getAggOprtEnumBySign(obj.getString("aggoprt")).getName();
    }

    protected void setParentAndChild(Map<Long, IDNumberTreeNode> id2Node, DynamicObjectCollection dcs) {
        HashSet parents = new HashSet(16);
        dcs.forEach(obj -> {
            IDNumberTreeNode baseNode;
            IDNumberTreeNode node = (IDNumberTreeNode)id2Node.get(obj.getLong("id"));
            IDNumberTreeNode pNode = (IDNumberTreeNode)id2Node.get(obj.getLong("parent"));
            if (pNode != null) {
                node.setParent(pNode);
                pNode.addChild(node);
                parents.add(pNode);
            }
            if (node != null && node.isShare() && (baseNode = (IDNumberTreeNode)id2Node.get(node.getCopyfromId())) != null) {
                baseNode.addShareNode(node);
            }
        });
        if (!parents.isEmpty()) {
            parents.forEach(p -> this.resetAllChildren((IDNumberTreeNode)p));
        }
    }

    private void resetAllChildren(IDNumberTreeNode node) {
        node.getChildType2AllChildren().clear();
        IDNumberTreeNode parent = node.getParent();
        if (parent != null && parent != IDNumberTreeNode.NotFoundTreeNode && !parent.getId().equals(node.getId())) {
            this.resetAllChildren(parent);
        }
    }

    protected IDNumberTreeNode createTreeNode(DynamicObject obj, Pair<Long, String> model, MemberReader.NodeList nodeList, Map<String, Tuple<Long, String, String>> dimMap) {
        String number = obj.getString("number");
        String dimNum = obj.getString("dimension.number");
        Map<Long, IDNumberTreeNode> id2Node = nodeList.getId2Node();
        Tuple dim = dimMap.compute(dimNum, (k, v) -> v == null ? Tuple.create(obj.getLong("dimension"), k, this.getEntityName()) : v);
        Map number2Node = nodeList.getNumber2Node().computeIfAbsent((String)dim.p2, (Function<String, Map<String, IDNumberTreeNode>>)((Function<String, Map>)k -> new LinkedHashMap(128)));
        Map number2ShareNode = nodeList.getNumber2ShareNode().computeIfAbsent((String)dim.p2, (Function<String, Map<String, List<IDNumberTreeNode>>>)((Function<String, Map>)k -> new LinkedHashMap(128)));
        Map upperNumber2Node = nodeList.getUpperCaseNumber2Node().computeIfAbsent(dimNum, k -> new HashMap(128));
        IDNumberTreeNode node = new IDNumberTreeNode(obj.getLong("id"), number, this.getAgg(obj), obj.getInt("dseq"), obj.getInt("level"), dim, StorageTypeEnum.stringToStorageType(obj.getString("storagetype")), obj.getBoolean("isleaf"), model, obj.getLong("copyfrom"), obj.getString("name"));
        id2Node.put(obj.getLong("id"), node);
        if (obj.getLong("copyfrom") == 0L) {
            number2Node.put(number, node);
            upperNumber2Node.put(number.toUpperCase(Locale.ENGLISH), node);
        } else {
            number2ShareNode.computeIfAbsent(number, k -> new ArrayList(16)).add(node);
        }
        this.addProperties(node, obj, number2Node);
        return node;
    }

    @Override
    public MemberReader.NodeList getAllNodes(String modelNum) {
        MemberReader.NodeList nodeList;
        long modelId = MemberReader.findModelIdByNum(modelNum);
        Pair<Long, String> model = Pair.onePair(modelId, modelNum);
        HashMap<String, Tuple<Long, String, String>> dimMap = new HashMap<String, Tuple<Long, String, String>>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        this.addQFilter(filter);
        if (SyncCacheUtil.isIncrementCache(this.getEntityName())) {
            String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, this.getEntityName());
            nodeList = (MemberReader.NodeList)CacheGenFactory.getDimMemberCacheCache().getIfPresent(cacheKey);
            if (nodeList != null) {
                String dimNum = DimEntityNumEnum.getNumberByEntieyNum(this.getEntityName());
                long dimId = MemberReader.getDimensionIdByNum(modelId, dimNum);
                Set<Long> ids = SyncCacheUtil.queryMemberCache(modelId, dimId, cacheKey).stream().map(m -> m.getLong("member")).collect(Collectors.toSet());
                this.removeDimensionCache(dimNum, nodeList, ids);
                BatchProcessHelper.handleAsync(() -> SyncCacheUtil.removeMemberCache(modelNum, dimNum));
                this.addTimeFilter(modelNum, filter);
                Map<Long, IDNumberTreeNode> id2Node = nodeList.getId2Node();
                DynamicObjectCollection docs = QueryServiceHelper.query((String)this.getEntityName(), (String)this.getSelectFields(), (QFilter[])filter.toArray(), (String)this.orderBy());
                log.error(String.format("reloadDimensionCache update size::%s,delete size::%s, modelNum::%s.", docs.size(), ids.size(), modelNum));
                if (docs == null || docs.isEmpty()) {
                    return nodeList;
                }
                DynamicObjectCollection newDocs = new DynamicObjectCollection();
                for (DynamicObject obj : docs) {
                    Long id = obj.getLong("id");
                    IDNumberTreeNode node = id2Node.get(id);
                    if (node != null) {
                        IDNumberTreeNode parentNode = null;
                        if (node.getParent() != null && node.getParent().getId().longValue() != obj.getLong("parent")) {
                            parentNode = id2Node.get(obj.getLong("parent"));
                        }
                        this.updateNode(node, obj, parentNode);
                        continue;
                    }
                    this.createTreeNode(obj, model, nodeList, dimMap);
                    newDocs.add((Object)obj);
                }
                this.setParentAndChild(id2Node, newDocs);
                return nodeList;
            }
        }
        nodeList = new MemberReader.NodeList();
        LinkedHashMap<Long, IDNumberTreeNode> id2Node = new LinkedHashMap<Long, IDNumberTreeNode>(128);
        HashMap<String, Map<String, IDNumberTreeNode>> dimNumber2Node = new HashMap<String, Map<String, IDNumberTreeNode>>(128);
        HashMap<String, Map<String, List<IDNumberTreeNode>>> dimNumber2ShareNode = new HashMap<String, Map<String, List<IDNumberTreeNode>>>(128);
        nodeList.setId2Node(id2Node);
        nodeList.setNumber2ShareNode(dimNumber2ShareNode);
        nodeList.setNumber2Node(dimNumber2Node);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)this.getEntityName(), (String)this.getSelectFields(), (QFilter[])filter.toArray(), (String)this.orderBy());
        if (docs == null || docs.isEmpty()) {
            return nodeList;
        }
        for (DynamicObject obj : docs) {
            this.createTreeNode(obj, model, nodeList, dimMap);
        }
        this.setParentAndChild(id2Node, docs);
        return nodeList;
    }

    private void updateNode(IDNumberTreeNode node, DynamicObject obj, IDNumberTreeNode parent) {
        node.initLocaleNames(obj.getString("name"));
        node.setdSeq(obj.getInt("dseq"));
        node.setLevel(obj.getInt("level"));
        node.setAggOprt(this.getAgg(obj));
        StorageTypeEnum type = StorageTypeEnum.UNSHARE.getOIndex().equals(obj.getString("storagetype")) ? null : StorageTypeEnum.stringToStorageType(obj.getString("storagetype"));
        node.setStorageType(type);
        if (parent != null) {
            node.getParent().getChildren().remove(node);
            node.setParent(parent);
            parent.getChildren().add(node);
        }
    }

    private void removeDimensionCache(String dimNum, MemberReader.NodeList nodeList, Set<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        Set removeNodes = nodeList.getId2Node().values().stream().filter(f -> ids.contains(f.getId())).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(removeNodes)) {
            return;
        }
        nodeList.getId2Node().values().removeAll(removeNodes);
        nodeList.getNumber2Node().get(dimNum).values().removeAll(removeNodes);
        nodeList.getUpperCaseNumber2Node().get(dimNum).values().removeAll(removeNodes);
        nodeList.getNumber2ShareNode().get(dimNum).values().removeAll(removeNodes);
        Set<IDNumberTreeNode> parentNodes = removeNodes.stream().map(m -> m.getParent()).collect(Collectors.toSet());
        if (!parentNodes.isEmpty()) {
            parentNodes.forEach(p -> p.getChildren().removeAll(removeNodes));
            parentNodes.forEach(p -> this.resetAllChildren((IDNumberTreeNode)p));
        }
    }
}

