/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.strategy.AbstractMemberQuery;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class EntityMemberQuery
extends AbstractMemberQuery {
    @Override
    public List<String> getProperties() {
        return Arrays.asList("currency.number", "cslscheme.id", "cslscheme.number", "isexchangerate", "orgcode", "parent.number", "isindependentorg", "isinnerorg");
    }

    @Override
    protected String getSelectFields() {
        String selectFields = "id,number,longnumber,name,dimension.number,dimension,model,level,issysmember,aggoprt,parent,copyfrom,dseq,storagetype,isleaf,parent.storagetype";
        if (!this.getProperties().isEmpty()) {
            selectFields = selectFields + "," + String.join((CharSequence)",", this.getProperties());
        }
        return selectFields;
    }

    @Override
    public String getEntityName() {
        return "bcm_entitymembertree";
    }

    @Override
    public void addQFilter(QFilter filter) {
        filter.and(new QFilter("status", "!=", (Object)"A"));
    }

    @Override
    protected String orderBy() {
        return "level,dseq";
    }

    @Override
    public void addProperties(IDNumberTreeNode node, DynamicObject obj, Map<String, IDNumberTreeNode> number2Node) {
        node.setCurrency(obj.getString("currency.number"));
        node.addProperty("cslscheme", obj.get("cslscheme.number"));
        String number = obj.getString("number");
        if (!"Entity".equals(number)) {
            String parentChildNum = obj.getString("parent.number") + "_" + number;
            if (!StorageTypeEnum.isShare(obj.getString("parent.storagetype"))) {
                number2Node.put(parentChildNum, node);
            }
        }
        this.getProperties().forEach(pro -> node.addProperty((String)pro, obj.get(pro)));
    }

    @Override
    protected IDNumberTreeNode createTreeNode(DynamicObject obj, Pair<Long, String> model, MemberReader.NodeList nodeList, Map<String, Tuple<Long, String, String>> dimMap) {
        IDNumberTreeNode node = super.createTreeNode(obj, model, nodeList, dimMap);
        node.setLongNumber(obj.getString("longnumber"));
        return node;
    }
}

