/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.cache.strategy;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.strategy.AbstractMemberQuery;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class PropertyMemberQuery
extends AbstractMemberQuery {
    @Override
    public String getEntityName() {
        return "bcm_definedpropertyvalue";
    }

    @Override
    public String getSelectFields() {
        return "id,number,longnumber,name,dimension.number,dimension,model,level,parentid,propertyid.id,propertyid.number";
    }

    @Override
    public String getAgg(DynamicObject obj) {
        return "";
    }

    @Override
    public IDNumberTreeNode createTreeNode(DynamicObject obj, Pair<Long, String> model, MemberReader.NodeList nodeList, Map<String, Tuple<Long, String, String>> dimMap) {
        String dimNumber = obj.getString("dimension.number");
        if (StringUtils.isEmpty((String)dimNumber)) {
            dimNumber = MemberReader.getDimensionNumById(obj.getLong("dimension"));
        }
        String number = obj.getString("number");
        IDNumberTreeNode node = new IDNumberTreeNode(obj.getLong("id"), number, "", 0, obj.getInt("level"), dimMap.compute(dimNumber, (k, v) -> v == null ? Tuple.create(obj.getLong("dimension"), k, this.getEntityName()) : v), StorageTypeEnum.DEFAULT, true, model, 0L, obj.getString("name"));
        Map number2Node = nodeList.getNumber2Node().computeIfAbsent(dimNumber, k -> new LinkedHashMap(16));
        node.addProperty("property.id", obj.getLong("propertyid.id"));
        node.addProperty("property.number", obj.getString("propertyid.number"));
        number2Node.put(number, node);
        nodeList.getId2Node().put(obj.getLong("id"), node);
        return node;
    }

    @Override
    public void setParentAndChild(Map<Long, IDNumberTreeNode> id2Node, DynamicObjectCollection dcs) {
        dcs.forEach(obj -> {
            IDNumberTreeNode baseNode;
            IDNumberTreeNode node = (IDNumberTreeNode)id2Node.get(obj.getLong("id"));
            IDNumberTreeNode pNode = (IDNumberTreeNode)id2Node.get(obj.getLong("parentid"));
            if (pNode != null) {
                node.setParent(pNode);
                pNode.addChild(node);
            }
            if (node != null && node.isShare() && (baseNode = (IDNumberTreeNode)id2Node.get(node.getCopyfromId())) != null) {
                baseNode.addShareNode(node);
            }
        });
    }
}

