/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.common.collect.QuickSearchList;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class DisBitSet<R, C>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final QuickSearchList<R> row;
    private final QuickSearchList<C> col;
    private final List<BitSet> bitdata;
    private static final String serSign = "DisBitSet";

    public DisBitSet(Set<R> r, Set<C> c) {
        this.row = new QuickSearchList<R>(r);
        this.col = new QuickSearchList<C>(c);
        this.bitdata = new ArrayList<BitSet>(r.size());
        for (R ignored : r) {
            this.bitdata.add(new BitSet(c.size()));
        }
    }

    public DisBitSet(Map<R, Set<C>> map) {
        this.row = new QuickSearchList<R>(map.keySet());
        HashSet<C> c = new HashSet<C>();
        for (Set<C> s : map.values()) {
            c.addAll(s);
        }
        this.col = new QuickSearchList(c);
        this.bitdata = new ArrayList<BitSet>(this.row.size());
        for (Set<Object> ignored : this.row) {
            this.bitdata.add(new BitSet(this.col.size()));
        }
        map.forEach(this::put);
    }

    public DisBitSet(String ss, Class<R> r, Class<C> c) {
        if (DisBitSet.isByteSerialized(ss)) {
            ss = ss.substring(serSign.length());
        }
        DisBitSet ds = (DisBitSet)ObjectSerialUtil.deSerializedBytes(ss);
        this.row = ds.row;
        this.col = ds.col;
        this.bitdata = ds.bitdata;
    }

    public String toByteSerialized() {
        return serSign + ObjectSerialUtil.toByteSerialized(this);
    }

    public static boolean isByteSerialized(String ss) {
        return ss != null && ss.startsWith(serSign);
    }

    public boolean isMatch(R key, C value) {
        int rowIndex = this.row.indexOf(key);
        int colIndex = this.col.indexOf(value);
        if (rowIndex != -1 && colIndex != -1) {
            return this.bitdata.get(rowIndex).get(colIndex);
        }
        return false;
    }

    public Set<C> get(R key) {
        HashSet set = new HashSet();
        int rowIndex = this.row.indexOf(key);
        if (rowIndex != -1) {
            BitSet bs = this.bitdata.get(rowIndex);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                set.add(this.col.get(i));
                i = bs.nextSetBit(i + 1);
            }
        }
        return set;
    }

    public void put(R key, Set<C> value) {
        this.put(key, (C)value, false);
    }

    public void put(R key, C value) {
        this.put(key, value, false);
    }

    public Map<R, Set<C>> toMap() {
        HashMap map = new HashMap();
        for (Object r : this.row) {
            map.put(r, this.get(r));
        }
        return map;
    }

    public void put(R key, Set<C> value, boolean newValue) {
        if (newValue) {
            if (!this.row.contains(key)) {
                this.row.add(key);
                this.bitdata.add(new BitSet());
            }
            for (C c : value) {
                if (this.col.contains(c)) continue;
                this.col.add(c);
            }
        }
        BitSet bs = this.bitdata.get(this.row.indexOf(key));
        for (C v : value) {
            bs.set(this.col.indexOf(v));
        }
    }

    public void put(R key, C value, boolean newValue) {
        if (newValue) {
            if (!this.row.contains(key)) {
                this.row.add(key);
                this.bitdata.add(new BitSet());
            }
            if (!this.col.contains(value)) {
                this.col.add(value);
            }
        }
        BitSet bs = this.bitdata.get(this.row.indexOf(key));
        bs.set(this.col.indexOf(value));
    }

    public static void main(String[] args) {
        HashSet<Long> row = new HashSet<Long>();
        row.add(1L);
        row.add(2L);
        row.add(3L);
        HashSet<Long> col = new HashSet<Long>();
        col.add(4L);
        col.add(5L);
        col.add(6L);
        DisBitSet cm2 = new DisBitSet(row, col);
        cm2.put(Long.valueOf(1L), 5L);
        cm2.put(Long.valueOf(2L), 4L);
        cm2.put(Long.valueOf(3L), 5L);
        cm2.put(Long.valueOf(3L), 6L);
        cm2.get(1L);
        cm2.get(2L);
        cm2.get(3L);
        cm2.isMatch(3L, 6L);
        cm2.isMatch(3L, 5L);
        cm2.isMatch(3L, 4L);
        Map map = cm2.toMap();
        new DisBitSet(map);
        new DisBitSet<Long, Long>(cm2.toByteSerialized(), Long.class, Long.class);
    }
}

