/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.collect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.fi.bcm.common.collect.IMemberCrossModel;
import kd.fi.bcm.common.collect.QuickSearchList;

public class MemberCrossModel
implements IMemberCrossModel {
    private List<List<String>> crossMems = new ArrayList<List<String>>();
    private List<List<Integer>> crossMembIdxs = new ArrayList<List<Integer>>();
    private BiMap<Integer, String> dimindex = HashBiMap.create();

    public MemberCrossModel() {
    }

    public MemberCrossModel(List<String> crossDims) {
        this.initParam(crossDims);
    }

    private void initParam(List<String> crossDims) {
        for (int i = 0; i < crossDims.size(); ++i) {
            this.dimindex.put((Object)i, (Object)crossDims.get(i));
            this.crossMems.add(new QuickSearchList());
        }
    }

    public void setCrossDims(List<String> crossDims) {
        this.initParam(crossDims);
    }

    public List<String> getCrossDims() {
        return new ArrayList<String>(this.dimindex.values());
    }

    @Override
    public void addCross(List<String> cross) {
        ArrayList<Integer> idxs = new ArrayList<Integer>(cross.size());
        for (int i = 0; i < cross.size(); ++i) {
            String mem = cross.get(i);
            List<String> curmems = this.crossMems.get(i);
            int index = curmems.indexOf(mem);
            if (index == -1) {
                index = curmems.size();
                curmems.add(mem);
            }
            idxs.add(index);
        }
        this.crossMembIdxs.add(idxs);
    }

    @Override
    public void iterateCrossDims(Consumer<Map<String, String>> consumer) {
        this.crossMembIdxs.forEach(midxs -> {
            Map<String, String> map = this.buildCrossMembByIndex((List<Integer>)midxs);
            consumer.accept(map);
        });
    }

    @Override
    public Map<String, String> get(int index) {
        if (index >= this.crossMembIdxs.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.crossMembIdxs.size());
        }
        return this.buildCrossMembByIndex(this.crossMembIdxs.get(index));
    }

    @Override
    public int size() {
        return this.crossMembIdxs.size();
    }

    public List<String> getDimMembers(String dim) {
        return this.crossMems.get((Integer)this.dimindex.inverse().get((Object)dim));
    }

    private Map<String, String> buildCrossMembByIndex(List<Integer> midxs) {
        HashMap<String, String> map = new HashMap<String, String>(midxs.size());
        for (int i = 0; i < midxs.size(); ++i) {
            map.put((String)this.dimindex.get((Object)i), this.crossMems.get(i).get(midxs.get(i)));
        }
        return map;
    }
}

