/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.collect;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.fi.bcm.common.collect.MemberCrossModel;

public class WithFixMemCrossModel
extends MemberCrossModel {
    Map<String, String> fixDims = new HashMap<String, String>();

    public WithFixMemCrossModel(List<String> crossDims) {
        super(crossDims);
    }

    public WithFixMemCrossModel() {
    }

    public void addFixDimension(String dim, String member) {
        this.fixDims.put(dim, member);
    }

    public Map<String, String> getFixDims() {
        return new HashMap<String, String>(this.fixDims);
    }

    @Override
    public void iterateCrossDims(Consumer<Map<String, String>> consumer) {
        super.iterateCrossDims(m -> {
            m.putAll(this.fixDims);
            consumer.accept((Map<String, String>)m);
        });
    }

    @Override
    public Map<String, String> get(int index) {
        Map<String, String> map = super.get(index);
        map.putAll(this.fixDims);
        return map;
    }

    @Override
    public List<String> getDimMembers(String dim) {
        if (this.fixDims.containsKey(dim)) {
            return Collections.singletonList(this.fixDims.get(dim));
        }
        return super.getDimMembers(dim);
    }
}

