/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.constant;

import java.lang.invoke.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.ReflectionUtils;
import kd.fi.bcm.common.constant.SFunction;

public class StringObjectMapWrapper<T extends Map<String, V>, V, K> {
    private static final Map<Class<?>, WeakReference<String>> FUNC_CACHE = new ConcurrentHashMap();
    private T stringObjectMap;

    public StringObjectMapWrapper(T stringObjectMap) {
        Assert.notNull(stringObjectMap);
        this.stringObjectMap = stringObjectMap;
    }

    public V get(SFunction<K, ?> columnLambda) {
        return this.stringObjectMap.get(this.getColumn(columnLambda));
    }

    public V put(SFunction<K, ?> columnLambda, V value) {
        return this.stringObjectMap.put((String)this.getColumn(columnLambda), value);
    }

    private String getColumn(SFunction columnLambda) {
        Class<?> clazz = columnLambda.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            String name;
            try {
                name = this.getColumn(columnLambda, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            FUNC_CACHE.put(clazz, new WeakReference<String>(name));
            return name;
        });
    }

    private String getColumn(SFunction getMethod, Class<? extends SFunction> clazz) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = clazz.getDeclaredMethod("writeReplace", new Class[0]);
        ReflectionUtils.makeAccessible((Method)method);
        Object invoke = method.invoke((Object)getMethod, new Object[0]);
        SerializedLambda lambda = (SerializedLambda)invoke;
        String name = lambda.getImplMethodName();
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            if (!name.startsWith("get") && !name.startsWith("set")) {
                throw new RuntimeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
            }
            name = name.substring(3);
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }
}

