/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.db;

import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DataSetUtil {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(true, DataSetUtil.class);

    public static String cacheDataSet(DataSet ds) {
        CacheHint hint = new CacheHint();
        hint.setTimeout(3600000L);
        CachedDataSet cachedDataSet = ds.cache(hint);
        return cachedDataSet.getCacheId();
    }

    public static List<Row> getData(String cacheId, int startIndex, int length) {
        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
        return cachedDataSet.getList(startIndex, length);
    }

    public static List<Row> getAllData(String cacheId) {
        try {
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
            return cachedDataSet.getList(0, cachedDataSet.getRowCount());
        }
        catch (AlgoException e) {
            log.error(e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u679c\u96c6\u7f13\u5b58\u672a\u627e\u5230\u6216\u5df2\u8d85\u65f6\u5931\u6548,\u8bf7\u9000\u51fa\u91cd\u65b0\u6253\u5f00\u3002", (String)"DataSetUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
    }

    public static void close(String cacheId) {
        Algo.removeCacheDataSet((String)cacheId);
    }

    public static void main(String[] args) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_accountmembertree", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)1615336513585820672L)}, null);
        String is = DataSetUtil.cacheDataSet(ds);
        DataSetUtil.getData(is, 0, 100);
        DataSetUtil.getData(is, 100, 100);
    }
}

