/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.disclosure.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DmPeriodAndFyUtil {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DmPeriodAndFyUtil.class);

    public static Boolean validCur(String origin) {
        String curcheck = origin;
        String validcur = "^(\\d[\\+\\-]\\$cur)|(\\$cur[\\+\\-]\\d{1,})|\\$cur$";
        Pattern pattern = Pattern.compile(validcur, 2);
        Matcher m = pattern.matcher(curcheck);
        if (!m.matches()) {
            return false;
        }
        return true;
    }

    public static Object getCurOffset(String origin) {
        String curcheck = origin;
        String validcur = "[\\+|\\-]\\d{1,}";
        Pattern pattern = Pattern.compile(validcur, 2);
        Matcher m = pattern.matcher(curcheck);
        if (m.find()) {
            String offset = m.group();
            return Integer.valueOf(offset);
        }
        return null;
    }

    public static String getPeriodOrFyByOffset(String shownumber, String fyorperiod, String cur, Object offset) {
        String cubeNumber = MemberReader.findModelNumberByShowNum(shownumber);
        Long modelId = MemberReader.findModelIdByNum(cubeNumber);
        QFilter qf1 = new QFilter("isleaf", "=", (Object)"1");
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter qf3 = new QFilter("status", "!=", (Object)"A");
        if (Objects.equals(fyorperiod, "FY")) {
            QFilter qf4 = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentYear", "LastYear"}));
            DynamicObjectCollection fys = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4}, (String)"dseq");
            List fylist = fys.stream().map(s -> s.getString("number")).sorted().collect(Collectors.toList());
            int index = fylist.indexOf(cur);
            int allsize = fylist.size();
            int c = index + (Integer)offset;
            if (c < 0) {
                return (String)fylist.get(0);
            }
            if (c >= allsize) {
                return (String)fylist.get(allsize - 1);
            }
            return (String)fylist.get(c);
        }
        if (Objects.equals(fyorperiod, "P")) {
            QFilter qf = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentPeriod", "LastPeriod"}));
            DynamicObjectCollection ps = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3}, (String)"dseq");
            List mlist = ps.stream().map(s -> s.getString("number")).collect(Collectors.toList());
            int i = cur.indexOf("_");
            if (i > 0) {
                String firstStr = cur.substring(0, i + 2);
                mlist = mlist.stream().filter(t -> t.startsWith(firstStr)).sorted().collect(Collectors.toList());
            }
            int index = mlist.indexOf(cur);
            int allsize = mlist.size();
            int c = index + (Integer)offset;
            if (c < 0) {
                return (String)mlist.get(0);
            }
            if (c >= allsize) {
                return (String)mlist.get(allsize - 1);
            }
            return (String)mlist.get(c);
        }
        return cur;
    }

    public static String[] getPeriodAndFyByOffset(String shownumber, String curfy, Object offsetfy, String curperiod, Object offsetperiod) {
        if (StringUtils.isEmpty((CharSequence)curfy) && StringUtils.isEmpty((CharSequence)curperiod)) {
            return new String[0];
        }
        String cubeNumber = MemberReader.findModelNumberByShowNum(shownumber);
        Long modelId = MemberReader.findModelIdByNum(cubeNumber);
        QFilter qf = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentPeriod", "LastPeriod"}));
        QFilter qf1 = new QFilter("isleaf", "=", (Object)"1");
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter qf3 = new QFilter("status", "!=", (Object)"A");
        DynamicObjectCollection ps = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3}, (String)"dseq");
        QFilter qf4 = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentYear", "LastYear"}));
        DynamicObjectCollection fys = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4}, (String)"dseq");
        QFilter qf5 = new QFilter("isadjust", "=", (Object)"1");
        DynamicObjectCollection adjusts = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number,isadjust,useyear", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf5}, (String)"dseq");
        Map<String, String> adjmap = adjusts.stream().collect(Collectors.toMap(s -> s.getString("number"), s -> s.getString("useyear")));
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(8);
        List fylist = fys.stream().map(s -> s.getString("number")).collect(Collectors.toList());
        List mlist = ps.stream().map(s -> s.getString("number")).collect(Collectors.toList());
        if (StringUtils.isEmpty((CharSequence)curfy)) {
            int index = mlist.indexOf(curperiod);
            int allsize = mlist.size();
            int c = Math.floorMod(index + (Integer)offsetperiod, allsize);
            String fyperiod = (String)mlist.get(c);
            return Lists.newArrayList((Object[])new String[]{"", fyperiod}).toArray(new String[0]);
        }
        if (StringUtils.isEmpty((CharSequence)curperiod)) {
            int index = fylist.indexOf(curfy);
            int allsize = fylist.size();
            int c = Math.floorMod(index + (Integer)offsetfy, allsize);
            String newfy = (String)fylist.get(c);
            return Lists.newArrayList((Object[])new String[]{newfy, ""}).toArray(new String[0]);
        }
        for (DynamicObject fy : fys) {
            String fynumber = fy.getString("number");
            map.put(fynumber, DmPeriodAndFyUtil.getValidPeriods(fynumber, ps, adjmap));
        }
        List<String> result = DmPeriodAndFyUtil.generateList(map);
        int index = result.indexOf(curfy + "|" + curperiod);
        int allsize = result.size();
        int c = Math.floorMod(index + (Integer)offsetperiod, allsize);
        String[] fyperiod = result.get(c).split("\\|");
        String newperiod = fyperiod[1];
        int index2 = fylist.indexOf(fyperiod[0]) + (Integer)offsetfy;
        String newfy = (String)fylist.get(index2);
        return Lists.newArrayList((Object[])new String[]{newfy, newperiod}).toArray(new String[0]);
    }

    private static List<String> getValidPeriods(String fynumber, DynamicObjectCollection ps, Map<String, String> adjmap) {
        ArrayList<String> validPeriod = new ArrayList<String>(ps.size());
        for (DynamicObject period : ps) {
            String pnumber = period.getString("number");
            String c = adjmap.get(pnumber);
            if (Objects.isNull(c)) {
                validPeriod.add(pnumber);
                continue;
            }
            if (!c.contains(fynumber)) continue;
            validPeriod.add(pnumber);
        }
        return validPeriod;
    }

    private static List<String> generateList(HashMap<String, List<String>> map) {
        ArrayList<String> result = new ArrayList<String>();
        map.forEach((k, v) -> v.forEach(s -> result.add(k + "|" + s)));
        return result;
    }
}

