/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class GroupCollection<E> {
    private List<E> fullList;
    private int length;
    private int size;
    private boolean removeAfterUsed;

    public void setRemoveAfterUsed(boolean removeAfterUsed) {
        this.removeAfterUsed = removeAfterUsed;
    }

    public GroupCollection(Collection<E> fullList, int length) {
        this.fullList = new ArrayList<E>(fullList);
        this.length = length;
        this.size = fullList.size() % length == 0 ? fullList.size() / length : fullList.size() / length + 1;
    }

    public int size() {
        return this.size;
    }

    public void iterator(Consumer<List<E>> consumer) {
        for (int i = 0; i < this.size(); ++i) {
            int min = i * this.length;
            int max = (i + 1) * this.length;
            if (i == this.size - 1) {
                max = this.fullList.size();
            }
            List<E> list = this.fullList.subList(min, max);
            consumer.accept(list);
            if (!this.removeAfterUsed) continue;
            this.fullList.removeAll(list);
            --i;
            --this.size;
        }
    }
}

