/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.dynamicObjectModel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.util.DynUtils;

public class LoadDynamicModel
implements IDynamicObjectModel<DynamicObject> {
    private Map<String, IDataEntityProperty> propertyMap;
    private final String algoKey;
    private boolean isUseAlgoKeyCache = false;
    private DynamicObject data;

    public LoadDynamicModel(DynamicObject data) {
        this(data.getDataEntityType().getName(), data);
    }

    public LoadDynamicModel(String algoKey, DynamicObject data) {
        this.algoKey = algoKey;
        this.data = data;
        this.isUseAlgoKeyCache = data != null && data.getDynamicObjectType().getSortProperties().size() > 10;
    }

    @Override
    public String getString(String propertyName) {
        return (String)ObjectConverter.convert((Object)this.get(propertyName), String.class, (boolean)true);
    }

    @Override
    public ILocaleString getLocaleString(String propertyName) {
        return new LocaleString(this.getString(propertyName));
    }

    @Override
    public int getInt(String propertyName) {
        return (Integer)ObjectConverter.convert((Object)this.get(propertyName), Integer.class, (boolean)false);
    }

    @Override
    public long getLong(String propertyName) {
        return (Long)ObjectConverter.convert((Object)this.get(propertyName), Long.class, (boolean)false);
    }

    @Override
    public boolean getBoolean(String propertyName) {
        return (Boolean)ObjectConverter.convert((Object)this.get(propertyName), Boolean.class, (boolean)false);
    }

    @Override
    public BigDecimal getBigDecimal(String propertyName) {
        return (BigDecimal)ObjectConverter.convert((Object)this.get(propertyName), BigDecimal.class, (boolean)false);
    }

    @Override
    public Date getDate(String propertyName) {
        return (Date)ObjectConverter.convert((Object)this.get(propertyName), Date.class, (boolean)false);
    }

    @Override
    public DynamicObject getDynamicObject(String propertyName) {
        return (DynamicObject)ObjectConverter.convert((Object)this.get(propertyName), DynamicObject.class, (boolean)false);
    }

    @Override
    public DynamicObjectCollection getDynamicObjectCollection(String propertyName) {
        return (DynamicObjectCollection)ObjectConverter.convert((Object)this.get(propertyName), DynamicObjectCollection.class, (boolean)false);
    }

    @Override
    public Object get(String propertyName) {
        if (this.isUseAlgoKeyCache) {
            IDataEntityProperty dp = this.searchIDataEntityProperty(propertyName);
            if (dp == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728", (String)"LoadDynamicModel_1", (String)"fi-bcm-common", (Object[])new Object[0]), propertyName));
            }
            return dp.getValueFast((Object)this.getData());
        }
        return this.getData().get(propertyName);
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.getData().containsProperty(propertyName);
    }

    @Override
    public void set(String propertyName, Object value) {
        this.getData().set(propertyName, value);
    }

    @Override
    public long getBaseDataId(String propertyName) {
        return DynUtils.getBaseId(this.getAlgoKey(), this.data, propertyName);
    }

    @Override
    public String getAlgoKey() {
        return this.algoKey;
    }

    @Override
    public DynamicObject getData() {
        return this.data;
    }

    @Override
    public void setData(DynamicObject data) {
        this.data = data;
    }

    @Override
    public IDynamicObjectModel copy(boolean isOrmCopy) {
        try {
            IDynamicObjectModel copy = (IDynamicObjectModel)this.clone();
            copy.setData(AdjustOperationUtils.copyDynamicObject(this.getData(), isOrmCopy));
            return copy;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public IDataEntityProperty searchIDataEntityProperty(String propertyName) {
        if (this.propertyMap == null) {
            this.propertyMap = (Map)ThreadCache.get((Object)this.getAlgoKey(), ConcurrentHashMap::new);
        }
        return this.propertyMap.computeIfAbsent(propertyName, a -> this.getData().getDynamicObjectType().getProperty(propertyName));
    }
}

