/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.entity;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.common.entity.EntityFieldTreeOption;
import kd.fi.bcm.common.entity.EntityFieldTreeResult;

class EntityFieldNodeHandle {
    private static final Log log = LogFactory.getLog(EntityFieldNodeHandle.class);
    private final EntityFieldTreeOption option;
    private final EntityFieldTreeResult result = new EntityFieldTreeResult();

    public EntityFieldNodeHandle(EntityFieldTreeOption option) {
        this.option = option;
    }

    public EntityFieldTreeResult getNodes() {
        try {
            this.buildFldTreeNodes(this.option.getEntityType(), this.option.getParentNode(), this.option.isReadEntryEntity(), false, null, "");
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
        }
        TreeNode sscApproveMsg = new TreeNode(this.option.getEntityType().getName(), "{sscApproveMsg}", ResManager.loadKDString((String)"\u7ef4\u5ea6\u5185\u90e8\u8bf4\u660e", (String)"EntityTreeUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]));
        TreeNode sscInnerMsg = new TreeNode(this.option.getEntityType().getName(), "{sscInnerMsg}", ResManager.loadKDString((String)"\u7ef4\u5ea6\u5185\u90e8\u8bf4\u660e", (String)"EntityTreeUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]));
        this.result.getNodes().add(sscApproveMsg);
        this.result.getNodes().add(sscInnerMsg);
        return this.result;
    }

    private void buildFldTreeNodes(IDataEntityType entityType, TreeNode parentNode, boolean readEntryEntity, boolean searchSubBaseData, TreeNode currentEntityNode, String prefix) throws CloneNotSupportedException {
        if (currentEntityNode == null) {
            String parentId = "";
            if (parentNode != null) {
                parentId = parentNode.getId();
            }
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            this.result.getNonFields().add(entityNodeId);
            currentEntityNode = new TreeNode(parentId, entityNodeId, entityNodeName);
        }
        int oriNodeCount = this.result.getNodes().size();
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (property instanceof EntryProp) {
                IDataEntityType childEntity;
                this.result.getNonFields().add(property.getName());
                if (!readEntryEntity || StringUtils.isBlank((CharSequence)(childEntity = ((EntryProp)property).getItemType()).getAlias())) continue;
                TreeNode entityNode = new TreeNode(currentEntityNode.getId(), property.getName(), property.getDisplayName().toString());
                this.buildFldTreeNodes(childEntity, currentEntityNode, readEntryEntity, searchSubBaseData, entityNode, prefix);
                continue;
            }
            if (property instanceof BasedataProp && DecimalProp.class.equals(this.option.getFieldType()) && searchSubBaseData) {
                BasedataProp bdProp = (BasedataProp)property;
                IDataEntityType bdType = bdProp.getComplexType();
                TreeNode entityNode = new TreeNode(currentEntityNode.getId(), property.getName(), property.getDisplayName().toString());
                String pfx = property.getName();
                if (!StringUtils.isBlank((CharSequence)prefix)) {
                    pfx = prefix + "." + property.getName();
                }
                this.buildFldTreeNodes(bdType, currentEntityNode, false, false, entityNode, pfx);
                continue;
            }
            TreeNode fldNode = this.buildFldTreeNode(property, currentEntityNode, prefix);
            if (fldNode == null) continue;
            this.result.getNodes().add(fldNode);
        }
        if (oriNodeCount != this.result.getNodes().size()) {
            this.result.getNodes().add(currentEntityNode);
        }
    }

    private void buildBDFldRefPropNodes(IDataEntityType bdType, TreeNode bdFldNode, String prefix, boolean loadSubBaseMeta) {
        for (IDataEntityProperty property : bdType.getProperties()) {
            TreeNode fldNode;
            if (property instanceof EntryProp || (fldNode = this.buildFldTreeNode(property, bdFldNode, prefix)) == null) continue;
            this.result.getNodes().add(fldNode);
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp bdProp2 = (BasedataProp)property;
            IDataEntityType bdType2 = bdProp2.getComplexType();
            if (loadSubBaseMeta && !(property instanceof FlexProp)) {
                try {
                    bdType2 = MetadataServiceHelper.getDataEntityType((String)bdType2.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            String prefix2 = prefix + "." + bdProp2.getName();
            this.buildBDFldRefPropNodes(bdType2, fldNode, prefix2, false);
        }
    }

    private TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix) {
        TreeNode fldNode = null;
        boolean isMatch = true;
        if (this.option.getFieldType() != null) {
            if (!this.option.getFieldType().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (DecimalProp.class.equals(this.option.getFieldType()) && fldProperty instanceof BigIntProp) {
                isMatch = false;
            }
        }
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null && (this.option.isIncludeID() && "id".equalsIgnoreCase(prop.getName()) || prop.getDisplayName() != null) && StringUtils.isNotEmpty((CharSequence)fldProperty.getAlias())) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
        }
        return fldNode;
    }
}

