/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public enum AccountDataTypeEnum {
    DEFAULT(AccountDataTypeEnum.getDEFAULT(), 0),
    CURRENCY(AccountDataTypeEnum.getCURRENCY(), 1),
    NOCURRENCY(AccountDataTypeEnum.getNOCURRENCY(), 2),
    TEXT(AccountDataTypeEnum.getTEXT(), 3),
    DATE(AccountDataTypeEnum.getDATE(), 4),
    RATIO(AccountDataTypeEnum.getRATIO(), 5),
    ENUM(AccountDataTypeEnum.getENUM(), 6);

    private String name;
    private int index;

    private AccountDataTypeEnum(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static AccountDataTypeEnum getAccountDataTypeEnumByIndex(int index) {
        for (AccountDataTypeEnum accountDataTypeEnum : AccountDataTypeEnum.values()) {
            if (accountDataTypeEnum.index != index) continue;
            return accountDataTypeEnum;
        }
        throw new KDBizException("error account data type : " + index);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static String getDEFAULT() {
        return ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"AccountDataTypeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getCURRENCY() {
        return ResManager.loadKDString((String)"\u8d27\u5e01", (String)"AccountDataTypeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getNOCURRENCY() {
        return ResManager.loadKDString((String)"\u6570\u503c", (String)"AccountDataTypeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getTEXT() {
        return ResManager.loadKDString((String)"\u6587\u672c", (String)"AccountDataTypeEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getDATE() {
        return ResManager.loadKDString((String)"\u65e5\u671f", (String)"AccountDataTypeEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getRATIO() {
        return ResManager.loadKDString((String)"\u6bd4\u4f8b", (String)"AccountDataTypeEnum_5", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getENUM() {
        return ResManager.loadKDString((String)"\u679a\u4e3e", (String)"AccountDataTypeEnum_6", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

