/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public enum ConvertFormulaEnum {
    BALANCE1(ConvertFormulaEnum.getBALANCE1(), 11, "CVT(\"cvtfactor@CurrPeriodSumAmount\")*"),
    PROFITLOSS1(ConvertFormulaEnum.getPROFITLOSS1(), 21, "CVT(\"cvtfactor@PeriodYDTSumAmount\")*"),
    PROFITLOSS2(ConvertFormulaEnum.getPROFITLOSS2(), 22, "CVT(\"cvtfactor@PreYDTSumCvtAmount\")+CVT(\"cvtfactor@PeriodSumAmount\")*"),
    PROFITLOSS3(ConvertFormulaEnum.getPROFITLOSS3(), 23, "CVT(\"cvtfactor@PeriodSumAmount\")*"),
    RIGHTS1(ConvertFormulaEnum.getRIGHTS1(), 31, "CVT(\"cvtfactor@PrePeriodSumCvtAmount\")+CVT(\"cvtfactor@PeriodSumAmount\")*"),
    RIGHTS2(ConvertFormulaEnum.getRIGHTS2(), 32, "CVT(\"cvtfactor@BeginYSumCvtAmount\")+CVT(\"cvtfactor@PeriodYDTSumAmount\")*");

    private String formula;
    public final int index;
    public final String cvtFactor;

    private ConvertFormulaEnum(String formula, int number, String cvtFactor) {
        this.formula = formula;
        this.index = number;
        this.cvtFactor = cvtFactor;
    }

    public String getFormula() {
        switch (this.index) {
            case 11: {
                return ConvertFormulaEnum.getBALANCE1();
            }
            case 21: {
                return ConvertFormulaEnum.getPROFITLOSS1();
            }
            case 22: {
                return ConvertFormulaEnum.getPROFITLOSS2();
            }
            case 23: {
                return ConvertFormulaEnum.getPROFITLOSS3();
            }
            case 31: {
                return ConvertFormulaEnum.getRIGHTS1();
            }
            case 32: {
                return ConvertFormulaEnum.getRIGHTS2();
            }
        }
        return this.formula;
    }

    public int getIndex() {
        return this.index;
    }

    public String getCvtFactor() {
        return this.cvtFactor;
    }

    public static ConvertFormulaEnum getConvertFormulaByIndex(int index) {
        for (ConvertFormulaEnum convertFormulaEnum : ConvertFormulaEnum.values()) {
            if (convertFormulaEnum.getIndex() != index) continue;
            return convertFormulaEnum;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684ConvertFormulaEnum\u7d22\u5f15: \u201c%s\u201d\u3002", (String)"ConvertFormulaEnum_6", (String)"fi-bcm-common", (Object[])new Object[0]), index));
    }

    private static String getBALANCE1() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u91d1\u989d=\u6298\u7b97\u524d\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getPROFITLOSS1() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u672c\u5e74\u7d2f\u8ba1\u91d1\u989d=\u6298\u7b97\u524d\u672c\u5e74\u7d2f\u8ba1\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getPROFITLOSS2() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u672c\u5e74\u7d2f\u8ba1\u91d1\u989d=\u4e0a\u671f\u6298\u7b97\u540e\u672c\u5e74\u7d2f\u8ba1\u6570+\u6298\u7b97\u524d\u672c\u671f\u53d1\u751f\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getPROFITLOSS3() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u672c\u671f\u91d1\u989d=\u6298\u7b97\u524d\u672c\u671f\u53d1\u751f\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getRIGHTS1() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u91d1\u989d=\u4e0a\u671f\u6298\u7b97\u540e\u6570+\u6298\u7b97\u524d\u672c\u671f\u53d1\u751f\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getRIGHTS2() {
        return ResManager.loadKDString((String)"\u6298\u7b97\u540e\u91d1\u989d=\u5e74\u521d\u6298\u7b97\u540e\u6570+\u6298\u7b97\u524d\u672c\u5e74\u7d2f\u8ba1\u6570*\u9002\u7528\u6c47\u7387", (String)"ConvertFormulaEnum_5", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

