/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.common.enums.DataPermDataTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum DataPermTypeEnum {
    NEW(1, new MultiLangEnumBridge("\u65b0\u589e", "DataPermTypeEnum_0", "fi-bcm-common"), "dimadd_box"),
    NoNEW(-1, new MultiLangEnumBridge("\u4e0d\u53ef\u65b0\u589e", "DataPermTypeEnum_1", "fi-bcm-common"), "dimadd_box"),
    EDIT(3, new MultiLangEnumBridge("\u4fee\u6539", "DataPermTypeEnum_2", "fi-bcm-common"), "dimedit_box"),
    NOEDIT(-3, new MultiLangEnumBridge("\u4e0d\u53ef\u4fee\u6539", "DataPermTypeEnum_3", "fi-bcm-common"), "dimedit_box"),
    DELETE(5, new MultiLangEnumBridge("\u5220\u9664", "DataPermTypeEnum_4", "fi-bcm-common"), "dimdel_box"),
    NODELETE(-5, new MultiLangEnumBridge("\u4e0d\u53ef\u5220\u9664", "DataPermTypeEnum_5", "fi-bcm-common"), "dimdel_box"),
    MANAGER(7, new MultiLangEnumBridge("\u7ba1\u7406", "DataPermTypeEnum_6", "fi-bcm-common"), "manager_box"),
    NOMANAGER(-7, new MultiLangEnumBridge("\u4e0d\u53ef\u7ba1\u7406", "DataPermTypeEnum_7", "fi-bcm-common"), "manager_box"),
    WRITE(13, new MultiLangEnumBridge("\u5199\u5165", "DataPermTypeEnum_8", "fi-bcm-common"), "membwrite_box"),
    NOWRITE(-13, new MultiLangEnumBridge("\u4e0d\u53ef\u5199\u5165", "DataPermTypeEnum_9", "fi-bcm-common"), "membwrite_box"),
    READ(11, new MultiLangEnumBridge("\u8bfb\u53d6", "DataPermTypeEnum_10", "fi-bcm-common"), "membread_box"),
    NOREAD(-11, new MultiLangEnumBridge("\u4e0d\u53ef\u8bfb\u53d6", "DataPermTypeEnum_11", "fi-bcm-common"), "membread_box"),
    VIEW(17, new MultiLangEnumBridge("\u53ef\u67e5\u770b", "DataPermTypeEnum_12", "fi-bcm-common"), "dataread_box"),
    NOVIEW(-17, new MultiLangEnumBridge("\u4e0d\u53ef\u67e5\u770b", "DataPermTypeEnum_13", "fi-bcm-common"), "dataread_box");

    public final int permNum;
    public final String permBoxKye;
    private MultiLangEnumBridge bridge;

    private DataPermTypeEnum(int permNum, MultiLangEnumBridge bridge, String permBoxKey) {
        this.bridge = bridge;
        this.permNum = permNum;
        this.permBoxKye = permBoxKey;
    }

    public static DataPermTypeEnum getPermTypeEnumByPermNum(int permNum) {
        DataPermTypeEnum result = null;
        switch (permNum) {
            case 1: {
                result = NEW;
                break;
            }
            case 3: {
                result = EDIT;
                break;
            }
            case 5: {
                result = DELETE;
                break;
            }
            case 7: {
                result = MANAGER;
                break;
            }
            case 11: {
                result = READ;
                break;
            }
            case 13: {
                result = WRITE;
                break;
            }
            case 17: {
                result = VIEW;
            }
        }
        return result;
    }

    public static int getPermNumByBoxKey(String boxKey) {
        int permNum = 0;
        switch (boxKey) {
            case "dimadd_box": {
                permNum = DataPermTypeEnum.NEW.permNum;
                break;
            }
            case "dimedit_box": {
                permNum = DataPermTypeEnum.EDIT.permNum;
                break;
            }
            case "dimdel_box": {
                permNum = DataPermTypeEnum.DELETE.permNum;
                break;
            }
            case "membread_box": {
                permNum = DataPermTypeEnum.READ.permNum;
                break;
            }
            case "membwrite_box": {
                permNum = DataPermTypeEnum.WRITE.permNum;
                break;
            }
            case "dimmanager_box": 
            case "datamanager_box": {
                permNum = DataPermTypeEnum.MANAGER.permNum;
                break;
            }
            case "dataread_box": {
                permNum = DataPermTypeEnum.VIEW.permNum;
            }
        }
        return permNum;
    }

    public static List<DataPermTypeEnum> getPermTypeListByDataType(int dataType, boolean isManager) {
        ArrayList<DataPermTypeEnum> types = new ArrayList<DataPermTypeEnum>();
        if (isManager) {
            types.add(MANAGER);
        } else {
            switch (dataType) {
                case 1: {
                    types.add(NEW);
                    types.add(EDIT);
                    types.add(DELETE);
                    break;
                }
                case 2: {
                    types.add(READ);
                    types.add(WRITE);
                    break;
                }
                case 3: {
                    types.add(VIEW);
                }
            }
        }
        return types;
    }

    public static List<String> getPermBoxKyesByDataType(int dataType, boolean isManager) {
        ArrayList<String> boxKeys = new ArrayList<String>();
        List<DataPermTypeEnum> types = DataPermTypeEnum.getPermTypeListByDataType(dataType, isManager);
        types.forEach(type -> boxKeys.add(type.permBoxKye));
        if (boxKeys.contains(DataPermTypeEnum.MANAGER.permBoxKye)) {
            if (dataType == 1) {
                boxKeys.set(0, "dim" + DataPermTypeEnum.MANAGER.permBoxKye);
            } else {
                boxKeys.set(0, "data" + DataPermTypeEnum.MANAGER.permBoxKye);
            }
        }
        return boxKeys;
    }

    public static int getDataTypeByPermEnum(DataPermTypeEnum permTypeEnum) {
        int dataType = 0;
        switch (permTypeEnum) {
            case NEW: 
            case EDIT: 
            case DELETE: {
                dataType = DataPermDataTypeEnum.DIMENSION.dataTypeNum;
                break;
            }
            case WRITE: 
            case READ: {
                dataType = DataPermDataTypeEnum.MEMBER.dataTypeNum;
                break;
            }
            case VIEW: {
                dataType = DataPermDataTypeEnum.REPORT.dataTypeNum;
            }
        }
        return dataType;
    }
}

