/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum DataSourceEnum {
    REPORTENTRY(new MultiLangEnumBridge("\u62a5\u8868\u5f55\u5165", "DataSourceEnum_0", "fi-bcm-common"), "1"),
    ENTRYADJUSTMENT(new MultiLangEnumBridge("\u5206\u5f55\u8c03\u6574", "DataSourceEnum_1", "fi-bcm-common"), "3"),
    TABLEADJUSTMENT(new MultiLangEnumBridge("\u8868\u5f0f\u8c03\u6574", "DataSourceEnum_2", "fi-bcm-common"), "4"),
    AUTOMATICCALCULATION(new MultiLangEnumBridge("\u81ea\u52a8\u8ba1\u7b97", "DataSourceEnum_3", "fi-bcm-common"), "5");

    public final String index;
    private int code;
    private MultiLangEnumBridge bridge;

    private DataSourceEnum(MultiLangEnumBridge bridge, String index) {
        this.bridge = bridge;
        this.index = index;
        this.code = Integer.parseInt(index);
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public final String getOIndex() {
        return this.index;
    }

    public int getCode() {
        return this.code;
    }

    public static DataSourceEnum getDataSourceEnumByIndex(String index) {
        int lookupCode;
        try {
            lookupCode = Integer.parseInt(index);
        }
        catch (Exception ex) {
            return REPORTENTRY;
        }
        for (DataSourceEnum dt : DataSourceEnum.values()) {
            if (dt.getCode() != lookupCode) continue;
            return dt;
        }
        return REPORTENTRY;
    }

    public static DataSourceEnum valueOfBy(String index) {
        int lookupCode = Integer.parseInt(index);
        for (DataSourceEnum dt : DataSourceEnum.values()) {
            if (dt.getCode() != lookupCode) continue;
            return dt;
        }
        throw new KDBizException(String.format("not fount dataType %s", index));
    }
}

