/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.dataentity.resource.ResManager;

public enum ElimTypeEnum {
    EICA("EICA", 1, ElimTypeEnum.getEICA()),
    EIT("EIT", 2, ElimTypeEnum.getEIT()),
    EOE("EOE", 3, ElimTypeEnum.getEOE()),
    ECF("ECF", 4, ElimTypeEnum.getECF()),
    ADJ("ADJ", 20, ElimTypeEnum.getADJ()),
    EOTHER("EOther", 9, ElimTypeEnum.getEOTHER()),
    EJE("EJE", 0, ElimTypeEnum.getEJE());

    private String number;
    private int value;
    private String name;

    private ElimTypeEnum(String number, int value, String name) {
        this.number = number;
        this.value = value;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static ElimTypeEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (ElimTypeEnum e : ElimTypeEnum.values()) {
            if (e.getValue() != type.intValue()) continue;
            return e;
        }
        throw new RuntimeException(ElimTypeEnum.class.getName() + "error value:" + type);
    }

    public static ElimTypeEnum getEnum(String number) {
        if (number == null) {
            return null;
        }
        for (ElimTypeEnum e : ElimTypeEnum.values()) {
            if (!e.getNumber().equals(number)) continue;
            return e;
        }
        throw new RuntimeException(ElimTypeEnum.class.getName() + "error value:" + number);
    }

    private static String getEICA() {
        return ResManager.loadKDString((String)"\u5f80\u6765\u7c7b", (String)"ElimTypeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getEIT() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b", (String)"ElimTypeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getEOE() {
        return ResManager.loadKDString((String)"\u6295\u8d44\u7c7b", (String)"ElimTypeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getECF() {
        return ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u7c7b", (String)"ElimTypeEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getADJ() {
        return ResManager.loadKDString((String)"\u8c03\u6574", (String)"ElimTypeEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getEOTHER() {
        return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ElimTypeEnum_5", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getEJE() {
        return ResManager.loadKDString((String)"\u62b5\u9500", (String)"ElimTypeEnum_6", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

