/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum PermSourceEnum {
    USER_MEMBER(1),
    USER_PERMCLASS(2),
    GROUP_MEMBER(4),
    GROUP_PERMCLASS(8);

    private int value;

    private PermSourceEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static List<Integer> allPermSource(PermSourceEnum permSource) {
        ArrayList list = Lists.newArrayList();
        Integer sum = Arrays.stream(PermSourceEnum.values()).mapToInt(val -> val.value).sum();
        for (int i = 1; i <= sum; ++i) {
            if (!PermSourceEnum.hasPermSource(i, permSource)) continue;
            list.add(i);
        }
        return list;
    }

    public static Integer addPermSource(Integer curSource, PermSourceEnum permSource) {
        if (PermSourceEnum.hasPermSource(curSource, permSource)) {
            return curSource;
        }
        return curSource | permSource.value;
    }

    public static boolean hasPermSource(Integer curSource, PermSourceEnum status) {
        return (curSource & status.value) != 0;
    }

    public static PermSourceEnum getByValue(Integer val) {
        for (PermSourceEnum p : PermSourceEnum.values()) {
            if (p.getValue() != val.intValue()) continue;
            return p;
        }
        return null;
    }
}

