/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum RangeEnum {
    VALUE_10("self", RangeEnum.getVALUE_10(), 10),
    VALUE_20("children", RangeEnum.getVALUE_20(), 20),
    VALUE_30("ichildren", RangeEnum.getVALUE_30(), 30),
    VALUE_40("descendants", RangeEnum.getVALUE_40(), 40),
    VALUE_50("idescendants", RangeEnum.getVALUE_50(), 50),
    VALUE_60("siblings", RangeEnum.getVALUE_60(), 60),
    VALUE_70("isibling", RangeEnum.getVALUE_70(), 70),
    VALUE_90("base", RangeEnum.getVALUE_90(), 90),
    VALUE_110("nonbase", RangeEnum.getVALUE_110(), 110),
    VALUE_10000("", RangeEnum.getVALUE_10000(), 10000),
    VALUE_20000("", RangeEnum.getVALUE_10000(), 20000),
    VALUE_300("300", RangeEnum.getVALUE_300(), 300),
    VALUE_310("310", RangeEnum.getVALUE_310(), 310);

    private String number;
    private String name;
    private int value;

    private RangeEnum(String number, String name, int value) {
        this.number = number;
        this.name = name;
        this.value = value;
    }

    public static RangeEnum getTempDistributeRangeByVal(int val) {
        for (RangeEnum r : RangeEnum.values()) {
            if (r.getValue() != val) continue;
            return r;
        }
        return null;
    }

    public static RangeEnum getRangeByVal(int val) {
        if (val >= VALUE_20000.getValue()) {
            return VALUE_20000;
        }
        if (val >= VALUE_10000.getValue()) {
            return VALUE_10000;
        }
        for (RangeEnum r : RangeEnum.values()) {
            if (r.getValue() != val) continue;
            return r;
        }
        throw new RuntimeException("RangeEnum error value:" + val);
    }

    public String getName() {
        switch (this.value) {
            case 10: {
                return RangeEnum.getVALUE_10();
            }
            case 20: {
                return RangeEnum.getVALUE_20();
            }
            case 30: {
                return RangeEnum.getVALUE_30();
            }
            case 40: {
                return RangeEnum.getVALUE_40();
            }
            case 50: {
                return RangeEnum.getVALUE_50();
            }
            case 60: {
                return RangeEnum.getVALUE_60();
            }
            case 70: {
                return RangeEnum.getVALUE_70();
            }
            case 90: {
                return RangeEnum.getVALUE_90();
            }
            case 110: {
                return RangeEnum.getVALUE_110();
            }
            case 10000: {
                return RangeEnum.getVALUE_10000();
            }
            case 300: {
                return RangeEnum.getVALUE_300();
            }
            case 310: {
                return RangeEnum.getVALUE_310();
            }
        }
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static void buildScopeShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal(val) == VALUE_10) {
            sb.append(name).append(',');
        } else if (val >= VALUE_10000.getValue()) {
            sb.append(name).append(RangeEnum.getVALUE_10000()).append(',');
        } else {
            String isStr = ResManager.loadKDString((String)"\u7684", (String)"RangeEnum_10", (String)"fi-bcm-common", (Object[])new Object[0]);
            sb.append(name).append(isStr).append(RangeEnum.getRangeByVal(val).getName()).append(',');
        }
    }

    private static String getVALUE_10() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4ec5\u81ea\u5df1", (String)"RangeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_20() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RangeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_30() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1", (String)"RangeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_40() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RangeEnum_3", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_50() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1", (String)"RangeEnum_4", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_60() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1", (String)"RangeEnum_5", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_70() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1", (String)"RangeEnum_6", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_90() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709_\u4ec5\u660e\u7ec6\u6210\u5458", (String)"RangeEnum_7", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_110() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709_\u4ec5\u975e\u660e\u7ec6\u6210\u5458", (String)"RangeEnum_8", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_10000() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5217\u8868", (String)"RangeEnum_9", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_300() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6240\u6709_\u975e\u72ec\u7acb\u7236\u7ea7\u8282\u70b9", (String)"RangeEnum_11", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    private static String getVALUE_310() {
        return new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4ec5\u81ea\u5df1_\u975e\u72ec\u7acb\u7236\u7ea7\u8282\u70b9", (String)"RangeEnum_12", (String)"fi-bcm-common", (Object[])new Object[0])).loadKDString();
    }

    public static RangeEnum getRangeByName(String name) {
        for (RangeEnum r : RangeEnum.values()) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        throw new RuntimeException("RangeEnum error name:" + name);
    }

    public static RangeEnum getRangeByNumber(String number) {
        for (RangeEnum r : RangeEnum.values()) {
            if (!r.getNumber().equals(number)) continue;
            return r;
        }
        return null;
    }

    public static RangeEnum getRangeByNumberOrName(String numberOrName) {
        for (RangeEnum r : RangeEnum.values()) {
            if (!r.getName().equals(numberOrName) && !r.getNumber().equals(numberOrName)) continue;
            return r;
        }
        throw new RuntimeException("RangeEnum error number or name:" + numberOrName);
    }

    public String getNumber() {
        return this.number;
    }
}

