/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum ReportStatusEnum {
    UNWEAVE("A", new MultiLangEnumBridge("\u672a\u7f16\u5236", "ReportStatusEnum_0", "fi-bcm-common"), "unweave"),
    WEAVING("B", new MultiLangEnumBridge("\u7f16\u5236\u4e2d", "ReportStatusEnum_1", "fi-bcm-common"), "weaving"),
    COMPLETE("C", new MultiLangEnumBridge("\u7f16\u5236\u5b8c\u6210", "ReportStatusEnum_2", "fi-bcm-common"), "complete"),
    COMMIT("D", new MultiLangEnumBridge("\u5df2\u4e0a\u62a5", "ReportStatusEnum_5", "fi-bcm-common"), "commit"),
    BACK("E", new MultiLangEnumBridge("\u88ab\u6253\u56de", "ReportStatusEnum_4", "fi-bcm-common"), "back"),
    BACKAPPLY("F", new MultiLangEnumBridge("\u7533\u8bf7\u6253\u56de", "ReportStatusEnum_6", "fi-bcm-common"), "backapply");

    private String status;
    private String text;
    private String number;
    private MultiLangEnumBridge bridge;

    private ReportStatusEnum(String status, MultiLangEnumBridge bridge, String number) {
        this.status = status;
        this.bridge = bridge;
        this.number = number;
    }

    public String status() {
        return this.status;
    }

    public String text() {
        return this.bridge.loadKDString();
    }

    public String number() {
        return this.number;
    }

    public static ReportStatusEnum getStatusEnumBy(String s) {
        for (ReportStatusEnum status : ReportStatusEnum.values()) {
            if (!s.equals(status.status())) continue;
            return status;
        }
        throw new KDBizException("error report status: " + s);
    }

    public static ReportStatusEnum getStatusEnumByNumber(String s) {
        for (ReportStatusEnum status : ReportStatusEnum.values()) {
            if (!s.equals(status.number())) continue;
            return status;
        }
        throw new KDBizException("error report status: " + s);
    }

    public static Tuple<String, String, String> getOperateMessage(ReportStatusEnum statusEnum) {
        String opName = "";
        switch (statusEnum) {
            case COMPLETE: {
                opName = ResManager.loadKDString((String)"\u7f16\u5236\u5b8c\u6210", (String)"ReportListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case UNWEAVE: 
            case WEAVING: {
                opName = ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u5236\u5b8c\u6210", (String)"ReportListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case COMMIT: {
                opName = ResManager.loadKDString((String)"\u4e0a\u62a5", (String)"ReportRecordUtil_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case BACK: {
                opName = ResManager.loadKDString((String)"\u6253\u56de", (String)"ReportListPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case BACKAPPLY: {
                opName = statusEnum.text();
            }
        }
        String successMessage = String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"ReportListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName);
        String failMessage = String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\u3002", (String)"ReportListPlugin_59", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName);
        return Tuple.create(opName, successMessage, failMessage);
    }

    public static String getIconClassByStatus(String status) {
        String iconClass = "icons/pc/state/gray_6_6.png";
        try {
            ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy(status);
            switch (statusEnum) {
                case UNWEAVE: {
                    iconClass = "icons/pc/state/orange_6_6.png";
                    break;
                }
                case WEAVING: {
                    iconClass = "icons/pc/state/hbbb_clz_6_6.png";
                    break;
                }
                case COMPLETE: {
                    iconClass = "icons/pc/state/hbbb_s_6_6.png";
                    break;
                }
                case COMMIT: {
                    iconClass = "icons/pc/state/blue_6_6.png";
                    break;
                }
                case BACK: {
                    iconClass = "icons/pc/state/red_6_6.png";
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iconClass;
    }

    public static String getColorByStatus(String status) {
        String color = "#6300BF";
        try {
            ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy(status);
            switch (statusEnum) {
                case UNWEAVE: {
                    color = "#F59A23";
                    break;
                }
                case WEAVING: {
                    color = "#0E5FD8";
                    break;
                }
                case COMPLETE: {
                    color = "#70B603";
                    break;
                }
                case COMMIT: {
                    color = "#00BFBF";
                    break;
                }
                case BACK: {
                    color = "#D9001B";
                    break;
                }
                default: {
                    color = "#6300BF";
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    public static List<ReportStatusEnum> getAllReportStatusEnum() {
        return Arrays.stream(ReportStatusEnum.values()).collect(Collectors.toList());
    }
}

