/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum StageOpTypeEnum {
    START("A", new MultiLangEnumBridge("\u6d41\u7a0b\u542f\u52a8", "StageOpTypeEnum_4", "fi-bcm-common"), "stagestart"),
    APPR("B", new MultiLangEnumBridge("\u6d41\u7a0b\u5ba1\u6279", "StageOpTypeEnum_2", "fi-bcm-common"), "stageappr"),
    COMMIT("C", new MultiLangEnumBridge("\u6d41\u7a0b\u63d0\u4ea4", "StageOpTypeEnum_1", "fi-bcm-common"), "stagecommit"),
    BACK("H", new MultiLangEnumBridge("\u6d41\u7a0b\u6253\u56de", "StageOpTypeEnum_3", "fi-bcm-common"), "stageback");

    private final String code;
    private final MultiLangEnumBridge bridge;
    private final String item;

    private StageOpTypeEnum(String code, MultiLangEnumBridge bridge, String item) {
        this.code = code;
        this.bridge = bridge;
        this.item = item;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.bridge.loadKDString();
    }

    public String getItem() {
        return this.item;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public static StageOpTypeEnum getEnumByCode(String code) {
        Optional<StageOpTypeEnum> first = Arrays.stream(StageOpTypeEnum.values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        return first.orElse(null);
    }
}

