/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;

public enum TemplateCatalogEnum {
    ROOT("root", "root", TemplateCatalogEnum.getRoot(), "TemplateCatalogEnum_0", "0", 0, TemplateCatalogTypeEnum.TEMPLATECATALOG.getType(), 1, false),
    MERGE_WP("mergeWP", "root.mergeWP", TemplateCatalogEnum.getMergeWP(), "TemplateCatalogEnum_1", "root", 1, TemplateCatalogTypeEnum.WPCATALOG.getType(), 1, true),
    CALCULATION_WP("calculationWP", "root.calculationWP", TemplateCatalogEnum.getCalculationWP(), "TemplateCatalogEnum_2", "root", 1, TemplateCatalogTypeEnum.WPCATALOG.getType(), 2, false),
    INVEST_WP("investWP", "root.calculationWP.investWP", TemplateCatalogEnum.getInvestWP(), "TemplateCatalogEnum_3", "calculationWP", 2, TemplateCatalogTypeEnum.WPCATALOG.getType(), 1, true),
    ADJUST_WP("adjustWP", "root.calculationWP.adjustWP", TemplateCatalogEnum.getAdjustWP(), "TemplateCatalogEnum_4", "calculationWP", 2, TemplateCatalogTypeEnum.WPCATALOG.getType(), 2, true),
    RULE_WP("ruleWP", "root.calculationWP.ruleWP", TemplateCatalogEnum.getRuleWP(), "TemplateCatalogEnum_5", "calculationWP", 2, TemplateCatalogTypeEnum.WPCATALOG.getType(), 3, true),
    PRTADJUST("RptAdjust", "root.RptAdjust", TemplateCatalogEnum.getRptAdjust(), "TemplateCatalogEnum_6", "root", 2, TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType(), 3, true, "3"),
    INNERTRADE("InnerTrade", "root.InnerTrade", TemplateCatalogEnum.getInnerTrade(), "TemplateCatalogEnum_7", "root", 2, TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType(), 2, true, "2"),
    INVELIM("InvElim", "root.InvElim", TemplateCatalogEnum.getInvElim(), "TemplateCatalogEnum_8", "root", 2, TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType(), 1, true, "1");

    private String number;
    private String longnumber;
    private int level;
    private String name;
    private String resourceId;
    private String parent;
    private char type;
    private int seq;
    private boolean isleaf;
    private String templatetype;

    private TemplateCatalogEnum(String number, String longnumber, String name, String resourceId, String parent, int level, char type, int seq, boolean isleaf) {
        this.number = number;
        this.name = name;
        this.resourceId = resourceId;
        this.longnumber = longnumber;
        this.parent = parent;
        this.level = level;
        this.type = type;
        this.seq = seq;
        this.isleaf = isleaf;
    }

    private TemplateCatalogEnum(String number, String longnumber, String name, String resourceId, String parent, int level, char type, int seq, boolean isleaf, String templatetype) {
        this.number = number;
        this.name = name;
        this.resourceId = resourceId;
        this.longnumber = longnumber;
        this.parent = parent;
        this.level = level;
        this.type = type;
        this.seq = seq;
        this.isleaf = isleaf;
        this.templatetype = templatetype;
    }

    public String getTemplatetype() {
        return this.templatetype;
    }

    public void setTemplatetype(String templatetype) {
        this.templatetype = templatetype;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getLocaleName() {
        return ResManager.loadKDString((String)this.name, (String)this.resourceId, (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public String getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }

    public char getType() {
        return this.type;
    }

    public int getSeq() {
        return this.seq;
    }

    public boolean isIsleaf() {
        return this.isleaf;
    }

    public static List<TemplateCatalogEnum> getWorkPaperCatalog() {
        ArrayList<TemplateCatalogEnum> result = new ArrayList<TemplateCatalogEnum>();
        for (TemplateCatalogEnum typeEnum : TemplateCatalogEnum.values()) {
            if (typeEnum.getType() != TemplateCatalogTypeEnum.WPCATALOG.getType()) continue;
            result.add(typeEnum);
        }
        return result;
    }

    public static List<TemplateCatalogEnum> getPaperCatalog() {
        ArrayList<TemplateCatalogEnum> result = new ArrayList<TemplateCatalogEnum>();
        for (TemplateCatalogEnum typeEnum : TemplateCatalogEnum.values()) {
            if (typeEnum.getType() != TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType()) continue;
            result.add(typeEnum);
        }
        return result;
    }

    public static String getNameByNumber(String number) {
        Optional<String> first = Arrays.stream(TemplateCatalogEnum.values()).filter(e -> Objects.equals(e.getNumber(), number)).map(TemplateCatalogEnum::getName).findFirst();
        return first.orElse(null);
    }

    public static Set<Long> getInnerTemplateCatalogIds(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(TemplateCatalogTypeEnum.getPaperTemplateCatalogFilter());
        qFilter.and("longnumber", "like", (Object)(TemplateCatalogEnum.INNERTRADE.longnumber + "%"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id,name", (QFilter[])qFilter.toArray());
        return collection.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
    }

    private static String getRoot() {
        return ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"TemplateCatalogEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getMergeWP() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u5de5\u4f5c\u5e95\u7a3f", (String)"TemplateCatalogEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getCalculationWP() {
        return ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u5de5\u4f5c\u5e95\u7a3f", (String)"TemplateCatalogEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getInvestWP() {
        return ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u8fc7\u7a0b\u5e95\u7a3f", (String)"TemplateCatalogEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getAdjustWP() {
        return ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u6a21\u677f\u5e95\u7a3f", (String)"TemplateCatalogEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getRuleWP() {
        return ResManager.loadKDString((String)"\u89c4\u5219\u8ba1\u7b97\u8fc7\u7a0b\u5e95\u7a3f", (String)"TemplateCatalogEnum_5", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getRptAdjust() {
        return ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55", (String)"TemplateCatalogEnum_6", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getInnerTrade() {
        return ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500", (String)"TemplateCatalogEnum_7", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getInvElim() {
        return ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500", (String)"TemplateCatalogEnum_8", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

