/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums;

import kd.bos.dataentity.resource.ResManager;

public enum YearScopeEnum {
    ALLYEAR("AllYear", "1", YearScopeEnum.getAllYear()),
    THISYEAR("ThisYear", "2", YearScopeEnum.getThisYear()),
    BEFOREYEAR("BeforeYear", "3", YearScopeEnum.getBeforeYear()),
    AFTERYEAR("AfterYear", "4", YearScopeEnum.getAfterYear());

    private String number;
    private String value;
    private String name;

    private YearScopeEnum(String number, String value, String name) {
        this.number = number;
        this.value = value;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        switch (this.value) {
            case "1": {
                return YearScopeEnum.getAllYear();
            }
            case "2": {
                return YearScopeEnum.getThisYear();
            }
            case "3": {
                return YearScopeEnum.getBeforeYear();
            }
            case "4": {
                return YearScopeEnum.getAfterYear();
            }
        }
        return this.name;
    }

    public static YearScopeEnum getEnumByType(String type) {
        if (type == null) {
            return null;
        }
        for (YearScopeEnum e : YearScopeEnum.values()) {
            if (!e.getValue().equals(type)) continue;
            return e;
        }
        throw new RuntimeException(YearScopeEnum.class.getName() + "error value:" + type);
    }

    public static YearScopeEnum getEnumByNumber(String number) {
        if (number == null) {
            return null;
        }
        for (YearScopeEnum e : YearScopeEnum.values()) {
            if (!e.getNumber().equals(number)) continue;
            return e;
        }
        throw new RuntimeException(YearScopeEnum.class.getName() + "error value:" + number);
    }

    private static String getAllYear() {
        return ResManager.loadKDString((String)"\u6240\u6709\u8d22\u5e74", (String)"YearScopeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getThisYear() {
        return ResManager.loadKDString((String)"\u4ec5\u5df2\u9009\u8d22\u5e74", (String)"YearScopeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getBeforeYear() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u524d\u8d22\u5e74", (String)"YearScopeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getAfterYear() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u540e\u8d22\u5e74", (String)"YearScopeEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

