/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.adjust;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;

public enum AdjustDataSortRuleEnum {
    NO_SORT(0),
    GROUPSEQ_SORT(1),
    SEQ_SORT(2),
    GROUP_SORT(3);

    private int sortRule;

    private AdjustDataSortRuleEnum(int sortRule) {
        this.sortRule = sortRule;
    }

    public int getSortRule() {
        return this.sortRule;
    }

    public void setSortRule(int sortRule) {
        this.sortRule = sortRule;
    }

    public Collection<IDynamicObjectModel> reSortModel(Collection<IDynamicObjectModel> list) {
        if (this.sortRule == GROUPSEQ_SORT.getSortRule()) {
            Comparator<IDynamicObjectModel> groupnumComparator = Comparator.comparing(a -> a.getString("groupnum"));
            Comparator<IDynamicObjectModel> dseqComparator = Comparator.comparing(a -> a.getString("dseq"));
            return list.stream().sorted(groupnumComparator.thenComparing(dseqComparator)).collect(Collectors.toList());
        }
        if (this.sortRule == SEQ_SORT.getSortRule()) {
            return list.stream().sorted(Comparator.comparing(a -> a.getString("dseq"))).collect(Collectors.toList());
        }
        return list;
    }

    public Collection<DynamicObject> reSort(Collection<DynamicObject> list) {
        if (this.sortRule == GROUPSEQ_SORT.getSortRule()) {
            Comparator<DynamicObject> groupnumComparator = Comparator.comparing(a -> a.getString("groupnum"));
            Comparator<DynamicObject> dseqComparator = Comparator.comparing(a -> a.getString("dseq"));
            return list.stream().sorted(groupnumComparator.thenComparing(dseqComparator)).collect(Collectors.toList());
        }
        if (this.sortRule == SEQ_SORT.getSortRule()) {
            return list.stream().sorted(Comparator.comparing(a -> a.getString("dseq"))).collect(Collectors.toList());
        }
        return list;
    }

    public Collection<DynamicObject> genDseq(Collection<DynamicObject> list) {
        Collection tempList = this.sortRule != GROUP_SORT.getSortRule() ? list : (Collection)list.stream().sorted(Comparator.comparing(a -> a.getString("groupnum"))).collect(Collectors.toList());
        int seq = 1;
        String len = String.valueOf(list.size());
        for (DynamicObject dy : tempList) {
            dy.set("dseq", (Object)String.format("%0" + len + "d", seq++));
        }
        return tempList;
    }
}

