/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.dimension;

import com.google.common.collect.Lists;
import java.util.List;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum SystemVarsEnum {
    PR_NONE("10", "PR_NONE", new MultiLangEnumBridge("\u7a7a", "SystemVarsEnum_1", "fi-bcm-common")),
    CURRENT("30", "$Cur", new MultiLangEnumBridge("\u5f53\u524d\u6210\u5458", "SystemVarsEnum_2", "fi-bcm-common")),
    RELATE_ENTITY("31", "$ECur", new MultiLangEnumBridge("\u5173\u8054\u7ec4\u7ec7", "SystemVarsEnum_3", "fi-bcm-common")),
    MC_INV_UNIT("32", "$EInv", new MultiLangEnumBridge("\u6295\u8d44\u5355\u4f4d", "SystemVarsEnum_4", "fi-bcm-common")),
    MC_SUB_UNIT("33", "$ESub", new MultiLangEnumBridge("\u88ab\u6295\u8d44\u5355\u4f4d", "SystemVarsEnum_5", "fi-bcm-common"));

    private String id;
    private String number;
    private MultiLangEnumBridge bridge;

    private SystemVarsEnum(String id, String number, MultiLangEnumBridge bridge) {
        this.id = id;
        this.number = number;
        this.bridge = bridge;
    }

    public String getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static boolean isDimVars(String pid) {
        for (SystemVarsEnum val : SystemVarsEnum.values()) {
            if (!val.getId().equals(pid) || val == PR_NONE) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimVarsByNumber(String number) {
        return SystemVarsEnum.getDimVarsByNumber(number) != null;
    }

    public static SystemVarsEnum getDimVarsByNumber(String number) {
        for (SystemVarsEnum val : SystemVarsEnum.values()) {
            if (!val.getNumber().equals(number) || val == PR_NONE) continue;
            return val;
        }
        return null;
    }

    public static List<String> getReportVars() {
        return Lists.newArrayList((Object[])new String[]{CURRENT.getNumber()});
    }

    public static List<String> getAdjustVars() {
        return Lists.newArrayList((Object[])new String[]{CURRENT.getNumber(), RELATE_ENTITY.getNumber(), MC_INV_UNIT.getNumber(), MC_SUB_UNIT.getNumber()});
    }

    public static List<String> getInvDimVars() {
        return Lists.newArrayList((Object[])new String[]{MC_INV_UNIT.getNumber(), MC_SUB_UNIT.getNumber()});
    }

    public static Long getDefaultModelId() {
        return 10000L;
    }

    public static Long getDefaultDimension() {
        return 10000L;
    }
}

