/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.integration;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;

public enum ComputeOprtEnum {
    PLUS("1", ComputeOprtEnum.getPLUS(), "plus", "+"),
    SUBTRACT("-1", ComputeOprtEnum.getSUBTRACT(), "subtract", "-");

    private String index;
    private String name;
    private String number;
    private String symbol;

    private ComputeOprtEnum(String index, String name, String number, String symbol) {
        this.name = name;
        this.number = number;
        this.index = index;
        this.symbol = symbol;
    }

    private static String getSUBTRACT() {
        return ResManager.loadKDString((String)"\u51cf", (String)"ComputeOprtEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getPLUS() {
        return ResManager.loadKDString((String)"\u52a0", (String)"ComputeOprtEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    public String getName() {
        switch (this.number) {
            case "subtract": {
                return ComputeOprtEnum.getSUBTRACT();
            }
        }
        return ComputeOprtEnum.getPLUS();
    }

    public String getNumber() {
        return this.number;
    }

    public String getIndex() {
        return this.index;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getIndexNum() {
        return Integer.parseInt(this.index);
    }

    @Deprecated
    public static ComputeOprtEnum getEnumByName(String name) {
        for (ComputeOprtEnum c : ComputeOprtEnum.values()) {
            if (!c.name.equals(name)) continue;
            return c;
        }
        return null;
    }

    public static ComputeOprtEnum getEnumByid(String index) {
        for (ComputeOprtEnum c : ComputeOprtEnum.values()) {
            if (!c.getIndex().equals(index)) continue;
            return c;
        }
        return null;
    }

    public static ComputeOprtEnum getEnumBySymbol(String symbol) {
        for (ComputeOprtEnum c : ComputeOprtEnum.values()) {
            if (!c.getSymbol().equals(symbol)) continue;
            return c;
        }
        return null;
    }

    public static String getNameByIndex(String index) {
        for (ComputeOprtEnum c : ComputeOprtEnum.values()) {
            if (!c.getIndex().equals(index)) continue;
            return c.getName();
        }
        return null;
    }

    public static String getIndexByName(String name) {
        for (ComputeOprtEnum c : ComputeOprtEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c.getIndex();
        }
        return null;
    }

    public static Set<String> getAllName() {
        return Stream.of(ComputeOprtEnum.values()).map(ComputeOprtEnum::getName).collect(Collectors.toSet());
    }
}

