/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.integration;

import kd.bos.dataentity.resource.ResManager;

public enum CurrencyTypeEnum {
    For("For", 1, CurrencyTypeEnum.getFor()),
    Local("Local", 2, CurrencyTypeEnum.getLocal()),
    Rpt("Rpt", 3, CurrencyTypeEnum.getRpt());

    private String number;
    private int value;

    private CurrencyTypeEnum(String number, int value, String name) {
        this.number = number;
        this.value = value;
    }

    private static String getRpt() {
        return ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"CurrencyTypeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getLocal() {
        return ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"CurrencyTypeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getFor() {
        return ResManager.loadKDString((String)"\u539f\u5e01", (String)"CurrencyTypeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    public String getNumber() {
        return this.number;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        switch (this.number) {
            case "Rpt": {
                return CurrencyTypeEnum.getRpt();
            }
            case "Local": {
                return CurrencyTypeEnum.getLocal();
            }
        }
        return CurrencyTypeEnum.getFor();
    }
}

