/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.integration;

import kd.bos.dataentity.resource.ResManager;

public enum DCEnum {
    Debit("Debit", 1, DCEnum.getDebit()),
    Credit("Credit", -1, DCEnum.getCredit());

    private String number;
    private int value;
    public static final int DEBIT_VAL = 1;
    public static final int CREDIT_VAL = -1;

    private DCEnum(String number, int value, String name) {
        this.number = number;
        this.value = value;
    }

    public String getNumber() {
        return this.number;
    }

    public int getValue() {
        return this.value;
    }

    public static DCEnum getEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (DCEnum e : DCEnum.values()) {
            if (e.getValue() != type.intValue()) continue;
            return e;
        }
        throw new RuntimeException(DCEnum.class.getName() + "error value:" + type);
    }

    public static DCEnum getEnum(String number) {
        if (number == null) {
            return null;
        }
        for (DCEnum e : DCEnum.values()) {
            if (!e.getNumber().equals(number)) continue;
            return e;
        }
        throw new RuntimeException(DCEnum.class.getName() + "error value:" + number);
    }

    private static String getDebit() {
        return ResManager.loadKDString((String)"\u501f", (String)"DCEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String getCredit() {
        return ResManager.loadKDString((String)"\u8d37", (String)"DCEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

