/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.integration;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum MapScopeEnum {
    EQUALS("1", new MultiLangEnumBridge("\u7b49\u4e8e", "MapScopeEnum_0", "fi-bcm-common"), "equals"),
    RANGE("2", new MultiLangEnumBridge("\u533a\u95f4", "MapScopeEnum_1", "fi-bcm-common"), "range"),
    LIKE("3", new MultiLangEnumBridge("\u76f8\u4f3c", "MapScopeEnum_2", "fi-bcm-common"), "like"),
    INCLUDE("4", new MultiLangEnumBridge("\u5305\u542b", "MapScopeEnum_3", "fi-bcm-common"), "include"),
    NOT_EQUALS("5", new MultiLangEnumBridge("\u4e0d\u7b49\u4e8e", "MapScopeEnum_4", "fi-bcm-common"), "not_equals"),
    NOT_RANGE("6", new MultiLangEnumBridge("\u4e0d\u5728\u533a\u95f4", "MapScopeEnum_5", "fi-bcm-common"), "not_range"),
    NOT_LIKE("7", new MultiLangEnumBridge("\u4e0d\u76f8\u4f3c", "MapScopeEnum_6", "fi-bcm-common"), "not_like"),
    NOT_INCLUDE("8", new MultiLangEnumBridge("\u4e0d\u5305\u542b", "MapScopeEnum_7", "fi-bcm-common"), "not_include");

    private String index;
    private String name;
    private String number;
    private MultiLangEnumBridge bridge;

    private MapScopeEnum(String index, MultiLangEnumBridge bridge, String number) {
        this.bridge = bridge;
        this.number = number;
        this.index = index;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public String getIndex() {
        return this.index;
    }

    public int getIndexNum() {
        return Integer.parseInt(this.index);
    }

    public static MapScopeEnum getEnumByName(String name) {
        for (MapScopeEnum c : MapScopeEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public static MapScopeEnum getEnumByindex(int index) {
        for (MapScopeEnum c : MapScopeEnum.values()) {
            if (c.getIndexNum() != index) continue;
            return c;
        }
        return null;
    }

    public static String getNameByIndex(String index) {
        for (MapScopeEnum c : MapScopeEnum.values()) {
            if (!c.getIndex().equals(index)) continue;
            return c.getName();
        }
        return null;
    }

    public static String getIndexByName(String Name) {
        for (MapScopeEnum c : MapScopeEnum.values()) {
            if (!c.getName().equals(Name)) continue;
            return c.getIndex();
        }
        return null;
    }

    public static Set<String> getAllName() {
        return Stream.of(MapScopeEnum.values()).map(MapScopeEnum::getName).collect(Collectors.toSet());
    }
}

